/* ========================================
 *  Flipity - Flipity.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Flipity.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Flipity {

Flipity::Flipity()
{
	A = 0.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Flipity::getParameterCount() const
{
  return kNumParameters;
}

void Flipity::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Flipity::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Flipity::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Flipity", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Flipity::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 7.999 )) //0 to almost edge of # of params
		{
			case 0: strncpy (text, "Dry", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "Flip L", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "Flip R", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "Flip LR", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "Swap LR", kVstMaxParamStrLen); break;
			case 5: strncpy (text, "Swip L", kVstMaxParamStrLen); break;
			case 6: strncpy (text, "Swip R", kVstMaxParamStrLen); break;
			case 7: strncpy (text, "Swip LR", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break; //E as example 'popup' parameter with four values  
        default: break; // unknown parameter, shouldn't happen!
	}
}

void Flipity::getParameterLabel(int index, char *text) {
    switch (index) {
		case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
