/* ========================================
 *  Fracture - Fracture.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Fracture.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Fracture {

Fracture::Fracture()
{
	A = 0.25; //1 from 0 to 4: A*4
	B = 0.5; //2 from 1 to 3: (B*2.999)+1
	C = 1.0;
	D = 1.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Fracture::getParameterCount() const
{
  return kNumParameters;
}

void Fracture::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Fracture::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Fracture::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Drive", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Fracture", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Out Lvl", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Fracture::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*4), text, kVstMaxParamStrLen); break;
        case kParamB: int2string ((int)floor(B * 2.999)+1, text, kVstMaxParamStrLen); break;
        case kParamC: dB2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Fracture::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break; //the percent
        case kParamC: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, " ", kVstMaxParamStrLen); break; //the popup
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
