/* ========================================
 *  GrindAmp - GrindAmp.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Gain_GrindAmp_H
#define __Gain_GrindAmp_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::GrindAmp {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class GrindAmp final : public SfxCoreExtensionV1
{
public:
    GrindAmp();
    ~GrindAmp();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double smoothAL;
	double smoothBL;
	double smoothCL;
	double smoothDL;
	double smoothEL;
	double smoothFL;
	double smoothGL;
	double smoothHL;
	double smoothIL;
	double smoothJL;
	double smoothKL;
	double secondAL;
	double secondBL;
	double secondCL;
	double secondDL;
	double secondEL;
	double secondFL;
	double secondGL;
	double secondHL;
	double secondIL;
	double secondJL;
	double secondKL;
	double thirdAL;
	double thirdBL;
	double thirdCL;
	double thirdDL;
	double thirdEL;
	double thirdFL;
	double thirdGL;
	double thirdHL;
	double thirdIL;
	double thirdJL;
	double thirdKL;
	double iirSampleAL;
	double iirSampleBL;
	double iirSampleCL;
	double iirSampleDL;
	double iirSampleEL;
	double iirSampleFL;
	double iirSampleGL;
	double iirSampleHL;
	double iirSampleIL;
	double iirLowpassL;
	double iirSubL;
	double storeSampleL; //amp
	
	double smoothAR;
	double smoothBR;
	double smoothCR;
	double smoothDR;
	double smoothER;
	double smoothFR;
	double smoothGR;
	double smoothHR;
	double smoothIR;
	double smoothJR;
	double smoothKR;
	double secondAR;
	double secondBR;
	double secondCR;
	double secondDR;
	double secondER;
	double secondFR;
	double secondGR;
	double secondHR;
	double secondIR;
	double secondJR;
	double secondKR;
	double thirdAR;
	double thirdBR;
	double thirdCR;
	double thirdDR;
	double thirdER;
	double thirdFR;
	double thirdGR;
	double thirdHR;
	double thirdIR;
	double thirdJR;
	double thirdKR;
	double iirSampleAR;
	double iirSampleBR;
	double iirSampleCR;
	double iirSampleDR;
	double iirSampleER;
	double iirSampleFR;
	double iirSampleGR;
	double iirSampleHR;
	double iirSampleIR;
	double iirLowpassR;
	double iirSubR;
	double storeSampleR; //amp
	
	double bL[90];
	double lastCabSampleL;
	double smoothCabAL;
	double smoothCabBL; //cab
	
	double bR[90];
	double lastCabSampleR;
	double smoothCabAR;
	double smoothCabBR; //cab
	
	double lastRefL[10];
	double lastRefR[10];
	int cycle;	//undersampling
	
	enum {
		fix_freq,
		fix_reso,
		fix_a0,
		fix_a1,
		fix_a2,
		fix_b1,
		fix_b2,
		fix_sL1,
		fix_sL2,
		fix_sR1,
		fix_sR2,
		fix_total
	}; //fixed frequency biquad filter for ultrasonics, stereo
	double fixA[fix_total];
	double fixB[fix_total];
	double fixC[fix_total];
	double fixD[fix_total];
	double fixE[fix_total];
	double fixF[fix_total]; //filtering
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
