/* ========================================
 *  Holt2 - Holt2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Holt2_Holt2_H
#define __Holt2_Holt2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Holt2 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
  kNumParameters = 5
}; //


class Holt2 final : public SfxCoreExtensionV1
{
public:
    Holt2();
    ~Holt2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

	double previousSampleAL;
	double previousTrendAL;
	double previousSampleBL;
	double previousTrendBL;
	double previousSampleCL;
	double previousTrendCL;
	double previousSampleDL;
	double previousTrendDL;
	double previousSampleEL;
	double previousTrendEL;
	double previousSampleFL;
	double previousTrendFL;
	double previousSampleGL;
	double previousTrendGL;
	double previousSampleHL;
	double previousTrendHL;
	
	double previousSampleAR;
	double previousTrendAR;
	double previousSampleBR;
	double previousTrendBR;
	double previousSampleCR;
	double previousTrendCR;
	double previousSampleDR;
	double previousTrendDR;
	double previousSampleER;
	double previousTrendER;
	double previousSampleFR;
	double previousTrendFR;
	double previousSampleGR;
	double previousTrendGR;
	double previousSampleHR;
	double previousTrendHR;
	
    float A;
    float B;
    float C;
    float D;
    float E; //parameters. Always 0-1, and we scale/alter them elsewhere.

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
