/* ========================================
 *  HypersonX - HypersonX.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "HypersonX.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::HypersonX {

HypersonX::HypersonX()
{
	A = 0.5;
	
	for (int x = 0; x < fix_total; x++) fixA[x] = 0.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int HypersonX::getParameterCount() const
{
  return kNumParameters;
}

void HypersonX::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float HypersonX::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void HypersonX::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Q", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void HypersonX::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 6.999 )) //0 to almost edge of # of params
		{	case kA: strncpy (text, "Reso A", kVstMaxParamStrLen); break;
			case kB: strncpy (text, "Reso B", kVstMaxParamStrLen); break;
			case kC: strncpy (text, "Reso C", kVstMaxParamStrLen); break;
			case kD: strncpy (text, "Reso D", kVstMaxParamStrLen); break;
			case kE: strncpy (text, "Reso E", kVstMaxParamStrLen); break;
			case kF: strncpy (text, "Reso F", kVstMaxParamStrLen); break;
			case kG: strncpy (text, "Reso G", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break;			
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void HypersonX::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
