/* ========================================
 *  MV - MV.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "MV.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::MV {

MV::MV()
{
	A = 0.5;
	B = 0.5;
	C = 0.5;
	D = 1.0;
	E = 1.0;
	
	int count;
	for(count = 0; count < 15149; count++) {aAL[count] = 0.0; aAR[count] = 0.0;}
	for(count = 0; count < 14617; count++) {aBL[count] = 0.0; aBR[count] = 0.0;}
	for(count = 0; count < 14357; count++) {aCL[count] = 0.0; aCR[count] = 0.0;}
	for(count = 0; count < 13817; count++) {aDL[count] = 0.0; aDR[count] = 0.0;}
	for(count = 0; count < 13561; count++) {aEL[count] = 0.0; aER[count] = 0.0;}
	for(count = 0; count < 13045; count++) {aFL[count] = 0.0; aFR[count] = 0.0;}
	for(count = 0; count < 11965; count++) {aGL[count] = 0.0; aGR[count] = 0.0;}
	for(count = 0; count < 11129; count++) {aHL[count] = 0.0; aHR[count] = 0.0;}
	for(count = 0; count < 10597; count++) {aIL[count] = 0.0; aIR[count] = 0.0;}
	for(count = 0; count < 9809; count++) {aJL[count] = 0.0; aJR[count] = 0.0;}
	for(count = 0; count < 9521; count++) {aKL[count] = 0.0; aKR[count] = 0.0;}
	for(count = 0; count < 8981; count++) {aLL[count] = 0.0; aLR[count] = 0.0;}
	for(count = 0; count < 8785; count++) {aML[count] = 0.0; aMR[count] = 0.0;}
	for(count = 0; count < 8461; count++) {aNL[count] = 0.0; aNR[count] = 0.0;}
	for(count = 0; count < 8309; count++) {aOL[count] = 0.0; aOR[count] = 0.0;}
	for(count = 0; count < 7981; count++) {aPL[count] = 0.0; aPR[count] = 0.0;}
	for(count = 0; count < 7321; count++) {aQL[count] = 0.0; aQR[count] = 0.0;}
	for(count = 0; count < 6817; count++) {aRL[count] = 0.0; aRR[count] = 0.0;}
	for(count = 0; count < 6505; count++) {aSL[count] = 0.0; aSR[count] = 0.0;}
	for(count = 0; count < 6001; count++) {aTL[count] = 0.0; aTR[count] = 0.0;}
	for(count = 0; count < 5837; count++) {aUL[count] = 0.0; aUR[count] = 0.0;}
	for(count = 0; count < 5501; count++) {aVL[count] = 0.0; aVR[count] = 0.0;}
	for(count = 0; count < 5009; count++) {aWL[count] = 0.0; aWR[count] = 0.0;}
	for(count = 0; count < 4849; count++) {aXL[count] = 0.0; aXR[count] = 0.0;}
	for(count = 0; count < 4295; count++) {aYL[count] = 0.0; aYR[count] = 0.0;}
	for(count = 0; count < 4179; count++) {aZL[count] = 0.0; aZR[count] = 0.0;}	
	
	alpA = 1; delayA = 7573; avgAL = 0.0; avgAR = 0.0;
	alpB = 1; delayB = 7307; avgBL = 0.0; avgBR = 0.0;
	alpC = 1; delayC = 7177; avgCL = 0.0; avgCR = 0.0;
	alpD = 1; delayD = 6907; avgDL = 0.0; avgDR = 0.0;
	alpE = 1; delayE = 6779; avgEL = 0.0; avgER = 0.0;
	alpF = 1; delayF = 6521; avgFL = 0.0; avgFR = 0.0;
	alpG = 1; delayG = 5981; avgGL = 0.0; avgGR = 0.0;
	alpH = 1; delayH = 5563; avgHL = 0.0; avgHR = 0.0;
	alpI = 1; delayI = 5297; avgIL = 0.0; avgIR = 0.0;
	alpJ = 1; delayJ = 4903; avgJL = 0.0; avgJR = 0.0;
	alpK = 1; delayK = 4759; avgKL = 0.0; avgKR = 0.0;
	alpL = 1; delayL = 4489; avgLL = 0.0; avgLR = 0.0;
	alpM = 1; delayM = 4391; avgML = 0.0; avgMR = 0.0;
	alpN = 1; delayN = 4229; avgNL = 0.0; avgNR = 0.0;
	alpO = 1; delayO = 4153; avgOL = 0.0; avgOR = 0.0;
	alpP = 1; delayP = 3989; avgPL = 0.0; avgPR = 0.0;
	alpQ = 1; delayQ = 3659; avgQL = 0.0; avgQR = 0.0;
	alpR = 1; delayR = 3407; avgRL = 0.0; avgRR = 0.0;
	alpS = 1; delayS = 3251; avgSL = 0.0; avgSR = 0.0;
	alpT = 1; delayT = 2999; avgTL = 0.0; avgTR = 0.0;
	alpU = 1; delayU = 2917; avgUL = 0.0; avgUR = 0.0;
	alpV = 1; delayV = 2749; avgVL = 0.0; avgVR = 0.0;
	alpW = 1; delayW = 2503; avgWL = 0.0; avgWR = 0.0;
	alpX = 1; delayX = 2423; avgXL = 0.0; avgXR = 0.0;
	alpY = 1; delayY = 2146; avgYL = 0.0; avgYR = 0.0;
	alpZ = 1; delayZ = 2088; avgZL = 0.0; avgZR = 0.0;
	
	feedbackL = 0.0;
	feedbackR = 0.0;
	
		fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int MV::getParameterCount() const
{
  return kNumParameters;
}

void MV::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float MV::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void MV::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Depth", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Bright", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Regen", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Output", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void MV::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void MV::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
