/* ========================================
 *  Melt - Melt.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Melt.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

namespace airwinconsolidated::Melt {

void Melt::processBlock(float **inputs, float **outputs, int sampleFrames) 
{
    float* in1  =  inputs[0];
    float* in2  =  inputs[1];
    float* out1 = outputs[0];
    float* out2 = outputs[1];
	
	double rate = 1 / (pow(A,2) + 0.001);
	double depthB = (B * 139.5)+2;
	double depthA = depthB * (1.0 - A);
	double output = C * 0.05;
	double wet = D;
	double dry = 1.0-wet;	


	double inputSampleL;
	double inputSampleR;
	double drySampleL;
	double drySampleR;
	
	minTap[0] = int(floor(2.0 * depthA)); maxTap[0] = int(floor(2.0 * depthB));
	minTap[1] = int(floor(3.0 * depthA)); maxTap[1] = int(floor(3.0 * depthB));
	minTap[2] = int(floor(5.0 * depthA)); maxTap[2] = int(floor(5.0 * depthB));
	minTap[3] = int(floor(7.0 * depthA)); maxTap[3] = int(floor(7.0 * depthB));
	minTap[4] = int(floor(11.0 * depthA)); maxTap[4] = int(floor(11.0 * depthB));
	minTap[5] = int(floor(13.0 * depthA)); maxTap[5] = int(floor(13.0 * depthB));
	minTap[6] = int(floor(17.0 * depthA)); maxTap[6] = int(floor(17.0 * depthB));
	minTap[7] = int(floor(19.0 * depthA)); maxTap[7] = int(floor(19.0 * depthB));
	minTap[8] = int(floor(23.0 * depthA)); maxTap[8] = int(floor(23.0 * depthB));
	minTap[9] = int(floor(29.0 * depthA)); maxTap[9] = int(floor(29.0 * depthB));
	minTap[10] = int(floor(31.0 * depthA)); maxTap[10] = int(floor(31.0 * depthB));
	minTap[11] = int(floor(37.0 * depthA)); maxTap[11] = int(floor(37.0 * depthB));
	minTap[12] = int(floor(41.0 * depthA)); maxTap[12] = int(floor(41.0 * depthB));
	minTap[13] = int(floor(43.0 * depthA)); maxTap[13] = int(floor(43.0 * depthB));
	minTap[14] = int(floor(47.0 * depthA)); maxTap[14] = int(floor(47.0 * depthB));
	minTap[15] = int(floor(53.0 * depthA)); maxTap[15] = int(floor(53.0 * depthB));
	minTap[16] = int(floor(59.0 * depthA)); maxTap[16] = int(floor(59.0 * depthB));
	minTap[17] = int(floor(61.0 * depthA)); maxTap[17] = int(floor(61.0 * depthB));
	minTap[18] = int(floor(67.0 * depthA)); maxTap[18] = int(floor(67.0 * depthB));
	minTap[19] = int(floor(71.0 * depthA)); maxTap[19] = int(floor(71.0 * depthB));
	minTap[20] = int(floor(73.0 * depthA)); maxTap[20] = int(floor(73.0 * depthB));
	minTap[21] = int(floor(79.0 * depthA)); maxTap[21] = int(floor(79.0 * depthB));
	minTap[22] = int(floor(83.0 * depthA)); maxTap[22] = int(floor(83.0 * depthB));
	minTap[23] = int(floor(89.0 * depthA)); maxTap[23] = int(floor(89.0 * depthB));
	minTap[24] = int(floor(97.0 * depthA)); maxTap[24] = int(floor(97.0 * depthB));
	minTap[25] = int(floor(101.0 * depthA)); maxTap[25] = int(floor(101.0 * depthB));
	minTap[26] = int(floor(103.0 * depthA)); maxTap[26] = int(floor(103.0 * depthB));
	minTap[27] = int(floor(107.0 * depthA)); maxTap[27] = int(floor(107.0 * depthB));
	minTap[28] = int(floor(109.0 * depthA)); maxTap[28] = int(floor(109.0 * depthB));
	minTap[29] = int(floor(113.0 * depthA)); maxTap[29] = int(floor(113.0 * depthB));
	minTap[30] = int(floor(117.0 * depthA)); maxTap[30] = int(floor(117.0 * depthB));
    
    while (--sampleFrames >= 0)
    {
		inputSampleL = *in1;
		inputSampleR = *in2;
		if (fabs(inputSampleL)<1.18e-23) inputSampleL = fpdL * 1.18e-17;
		if (fabs(inputSampleR)<1.18e-23) inputSampleR = fpdR * 1.18e-17;
		drySampleL = inputSampleL;
		drySampleR = inputSampleR;

		if (gcount < 0 || gcount > 16000) {gcount = 16000;}
		dL[gcount+16000] = dL[gcount] = float(inputSampleL);
		dR[gcount+16000] = dR[gcount] = float(inputSampleR);
		
		if (slowCount > rate || slowCount < 0) {
			slowCount = 0;
			stepCount++;
			if (stepCount > 29 || stepCount < 0) {stepCount = 0;}
			position[stepCount] += stepTap[stepCount];
			if (position[stepCount] < minTap[stepCount]) {
				position[stepCount] = minTap[stepCount];
				stepTap[stepCount] = 1;
			}
			if (position[stepCount] > maxTap[stepCount]) {
				position[stepCount] = maxTap[stepCount];
				stepTap[stepCount] = -1;
			}
		}
		
		//begin L
		scalefactorL *= 0.9999f;
		scalefactorL += (100.0f - fabsf(combineL)) * 0.000001f;
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[29]]);
		combineL += (dL[gcount+position[28]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[27]]);
		combineL += (dL[gcount+position[26]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[25]]);
		combineL += (dL[gcount+position[24]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[23]]);
		combineL += (dL[gcount+position[22]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[21]]);
		combineL += (dL[gcount+position[20]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[19]]);
		combineL += (dL[gcount+position[18]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[17]]);
		combineL += (dL[gcount+position[16]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[15]]);
		combineL += (dL[gcount+position[14]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[13]]);
		combineL += (dL[gcount+position[12]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[11]]);
		combineL += (dL[gcount+position[10]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[9]]);
		combineL += (dL[gcount+position[8]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[7]]);
		combineL += (dL[gcount+position[6]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[5]]);
		combineL += (dL[gcount+position[4]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[3]]);
		combineL += (dL[gcount+position[2]]);
		
		combineL *= scalefactorL;
		combineL -= (dL[gcount+position[1]]);
		combineL += (dL[gcount+position[0]]);
		
		inputSampleL = combineL;
		//done with L
		
		//begin R
		scalefactorR *= 0.9999f;
		scalefactorR += (100.0f - fabsf(combineR)) * 0.000001f;
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[29]]);
		combineR += (dR[gcount+position[28]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[27]]);
		combineR += (dR[gcount+position[26]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[25]]);
		combineR += (dR[gcount+position[24]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[23]]);
		combineR += (dR[gcount+position[22]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[21]]);
		combineR += (dR[gcount+position[20]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[19]]);
		combineR += (dR[gcount+position[18]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[17]]);
		combineR += (dR[gcount+position[16]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[15]]);
		combineR += (dR[gcount+position[14]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[13]]);
		combineR += (dR[gcount+position[12]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[11]]);
		combineR += (dR[gcount+position[10]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[9]]);
		combineR += (dR[gcount+position[8]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[7]]);
		combineR += (dR[gcount+position[6]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[5]]);
		combineR += (dR[gcount+position[4]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[3]]);
		combineR += (dR[gcount+position[2]]);
		
		combineR *= scalefactorR;
		combineR -= (dR[gcount+position[1]]);
		combineR += (dR[gcount+position[0]]);
		
		inputSampleR = combineR;
		//done with R
		
		gcount--;
		slowCount++;

		if (output < 1.0) {inputSampleL *= output; inputSampleR *= output;}
		if (wet < 1.0) {
			inputSampleL = (drySampleL * dry)+(inputSampleL*wet);
			inputSampleR = (drySampleR * dry)+(inputSampleR*wet);
		}
		//nice little output stage template: if we have another scale of floating point
		//number, we really don't want to meaninglessly multiply that by 1.0.
				
		//begin 32 bit stereo floating point dither
		int expon; frexpf((float)inputSampleL, &expon);
		fpdL ^= fpdL << 13; fpdL ^= fpdL >> 17; fpdL ^= fpdL << 5;
		inputSampleL += double((double(fpdL)-uint32_t(0x7fffffff)) * 5.5e-36l * pow(2.0,expon+62.0));
		frexpf((float)inputSampleR, &expon);
		fpdR ^= fpdR << 13; fpdR ^= fpdR >> 17; fpdR ^= fpdR << 5;
		inputSampleR += double((double(fpdR)-uint32_t(0x7fffffff)) * 5.5e-36l * pow(2.0,expon+62.0));
		//end 32 bit stereo floating point dither

		*out1 = float(inputSampleL);
		*out2 = float(inputSampleR);

		in1++;
		in2++;
		out1++;
		out2++;
    }
}

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
