/* ========================================
 *  Monitoring2 - Monitoring2.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Monitoring2.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Monitoring2 {

Monitoring2::Monitoring2()
{
	for(int count = 0; count < 99; count++) {
		darkSampleL[count] = 0;
		darkSampleR[count] = 0;
	}
	
	for(int count = 0; count < 1502; count++) {
		aL[count] = 0.0; bL[count] = 0.0; cL[count] = 0.0; dL[count] = 0.0;
		aR[count] = 0.0; bR[count] = 0.0; cR[count] = 0.0; dR[count] = 0.0;
	}
	ax = 1; bx = 1; cx = 1; dx = 1;
	//PeaksOnly
	lastSampleL = 0.0; lastSampleR = 0.0;
	//SlewOnly
	iirSampleAL = 0.0; iirSampleBL = 0.0; iirSampleCL = 0.0; iirSampleDL = 0.0; iirSampleEL = 0.0; iirSampleFL = 0.0; iirSampleGL = 0.0;
	iirSampleHL = 0.0; iirSampleIL = 0.0; iirSampleJL = 0.0; iirSampleKL = 0.0; iirSampleLL = 0.0; iirSampleML = 0.0; iirSampleNL = 0.0; iirSampleOL = 0.0; iirSamplePL = 0.0;
	iirSampleQL = 0.0; iirSampleRL = 0.0; iirSampleSL = 0.0;
	iirSampleTL = 0.0; iirSampleUL = 0.0; iirSampleVL = 0.0;
	iirSampleWL = 0.0; iirSampleXL = 0.0; iirSampleYL = 0.0; iirSampleZL = 0.0;
	
	iirSampleAR = 0.0; iirSampleBR = 0.0; iirSampleCR = 0.0; iirSampleDR = 0.0; iirSampleER = 0.0; iirSampleFR = 0.0; iirSampleGR = 0.0;
	iirSampleHR = 0.0; iirSampleIR = 0.0; iirSampleJR = 0.0; iirSampleKR = 0.0; iirSampleLR = 0.0; iirSampleMR = 0.0; iirSampleNR = 0.0; iirSampleOR = 0.0; iirSamplePR = 0.0;
	iirSampleQR = 0.0; iirSampleRR = 0.0; iirSampleSR = 0.0;
	iirSampleTR = 0.0; iirSampleUR = 0.0; iirSampleVR = 0.0;
	iirSampleWR = 0.0; iirSampleXR = 0.0; iirSampleYR = 0.0; iirSampleZR = 0.0; // o/`	
	//SubsOnly
	for (int x = 0; x < fix_total; x++) {biquad[x] = 0.0;}
	//Bandpasses
	A = 0.0;

	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Monitoring2::getParameterCount() const
{
  return kNumParameters;
}

void Monitoring2::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Monitoring2::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Monitoring2::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Monitor", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Monitoring2::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 16.999 )) //0 to almost edge of # of params
		{	case kDKAD: strncpy (text, "Out24", kVstMaxParamStrLen); break;
			case kDKCD: strncpy (text, "Out16", kVstMaxParamStrLen); break;
			case kPEAK: strncpy (text, "Peaks", kVstMaxParamStrLen); break;
			case kSLEW: strncpy (text, "Slew", kVstMaxParamStrLen); break;
			case kSUBS: strncpy (text, "Subs", kVstMaxParamStrLen); break;
			case kMONO: strncpy (text, "Mono", kVstMaxParamStrLen); break;
			case kSIDE: strncpy (text, "Side", kVstMaxParamStrLen); break;
			case kVINYL: strncpy (text, "Vinyl", kVstMaxParamStrLen); break;
			case kAURAT: strncpy (text, "Aurat", kVstMaxParamStrLen); break;
			case kMONORAT: strncpy (text, "MonoRat", kVstMaxParamStrLen); break;
			case kMONOLAT: strncpy (text, "MonoLat", kVstMaxParamStrLen); break;
			case kPHONE: strncpy (text, "Phone", kVstMaxParamStrLen); break;
			case kCANSA: strncpy (text, "Cans A", kVstMaxParamStrLen); break;
			case kCANSB: strncpy (text, "Cans B", kVstMaxParamStrLen); break;
			case kCANSC: strncpy (text, "Cans C", kVstMaxParamStrLen); break;
			case kCANSD: strncpy (text, "Cans D", kVstMaxParamStrLen); break;
			case kTRICK: strncpy (text, "V Trick", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break;			
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Monitoring2::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
