/* ========================================
 *  Monitoring3 - Monitoring3.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Monitoring3_Monitoring3_H
#define __Monitoring3_Monitoring3_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Monitoring3 {
enum {
	kParamA = 0,
	kNumParameters = 1
}; //

enum {
    kDKAD,
    kDKCD,
    kPEAK,
    kSLEW,
    kSUBS,
    kMONO,
    kSIDE,
    kVINYL,
    kAURAT,
    kMONORAT,
    kMONOLAT,
    kPHONE,
    kCANSA,
    kCANSB,
    kCANSC,
    kCANSD,
    kTRICK,
};


class Monitoring3 final : public SfxCoreExtensionV1
{
public:
    Monitoring3();
    ~Monitoring3();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	enum {
		fix_freq,
		fix_reso,
		fix_a0,
		fix_a1,
		fix_a2,
		fix_b1,
		fix_b2,
		fix_sL1,
		fix_sL2,
		fix_sR1,
		fix_sR2,
		fix_total
	};
	double biquad[fix_total];
	//Bandpasses
	
	double NSOddL;
	double NSEvenL;
	double prevShapeL;
	double NSOddR;
	double NSEvenR;
	double prevShapeR;
	bool flip; //VinylDither
	double darkSampleL[100];
	double darkSampleR[100];
	int depth; //Dark
	
	double aL[1503], bL[1503], cL[1503], dL[1503];
	double aR[1503], bR[1503], cR[1503], dR[1503];
	int ax, bx, cx, dx;
	//PeaksOnly
	double lastSampleL, lastSampleR;
	//SlewOnly
	double iirSampleAL, iirSampleBL, iirSampleCL, iirSampleDL, iirSampleEL, iirSampleFL, iirSampleGL;
	double iirSampleHL, iirSampleIL, iirSampleJL, iirSampleKL, iirSampleLL, iirSampleML, iirSampleNL, iirSampleOL, iirSamplePL;
	double iirSampleQL, iirSampleRL, iirSampleSL;
	double iirSampleTL, iirSampleUL, iirSampleVL;
	double iirSampleWL, iirSampleXL, iirSampleYL, iirSampleZL;
	
	double iirSampleAR, iirSampleBR, iirSampleCR, iirSampleDR, iirSampleER, iirSampleFR, iirSampleGR;
	double iirSampleHR, iirSampleIR, iirSampleJR, iirSampleKR, iirSampleLR, iirSampleMR, iirSampleNR, iirSampleOR, iirSamplePR;
	double iirSampleQR, iirSampleRR, iirSampleSR;
	double iirSampleTR, iirSampleUR, iirSampleVR;
	double iirSampleWR, iirSampleXR, iirSampleYR, iirSampleZR; // o/`
	//SubsOnly
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
    float A;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
