/* ========================================
 *  MultiBandDistortion - MultiBandDistortion.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "MultiBandDistortion.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::MultiBandDistortion {

MultiBandDistortion::MultiBandDistortion()
{
	A = 0.5;
	B = 0.0;
	C = 0.0;
	D = 0.0;
	E = 0.0;
	F = 1.0;
	G = 1.0;
	H = 1.0;
	I = 0.75;
	
	ataLast3SampleL = ataLast2SampleL = ataLast1SampleL = 0.0;
	ataHalfwaySampleL = ataHalfDrySampleL = ataHalfDiffSampleL = 0.0;
	ataAL = ataBL = ataCL = ataDrySampleL = ataDiffSampleL = ataPrevDiffSampleL = 0.0;
	ataUpsampleHighTweakL = 0.0414213562373095048801688; //more adds treble to upsampling
	ataDecayL = 0.915965594177219015; //Catalan's constant, more adds focus and clarity
	iirSampleAL = 0; iirSampleBL = 0;

	ataFlip = false; //end reset of antialias parameters

	ataLast3SampleR = ataLast2SampleR = ataLast1SampleR = 0.0;
	ataHalfwaySampleR = ataHalfDrySampleR = ataHalfDiffSampleR = 0.0;
	ataAR = ataBR = ataCR = ataDrySampleR = ataDiffSampleR = ataPrevDiffSampleR = 0.0;
	ataUpsampleHighTweakR = 0.0414213562373095048801688; //more adds treble to upsampling
	ataDecayR = 0.915965594177219015; //Catalan's constant, more adds focus and clarity
	iirSampleAR = 0; iirSampleBR = 0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int MultiBandDistortion::getParameterCount() const
{
  return kNumParameters;
}

void MultiBandDistortion::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        case kParamF: F = value; break;
        case kParamG: G = value; break;
        case kParamH: H = value; break;
        case kParamI: I = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float MultiBandDistortion::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        case kParamG: return G; break;
        case kParamH: return H; break;
        case kParamI: return I; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void MultiBandDistortion::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Freqcy", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "H Gain", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "L Gain", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "H Hard", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "L Hard", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "H Mtrx", kVstMaxParamStrLen); break;
		case kParamG: strncpy (text, "L Mtrx", kVstMaxParamStrLen); break;
		case kParamH: strncpy (text, "Stable", kVstMaxParamStrLen); break;
		case kParamI: strncpy (text, "Output", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void MultiBandDistortion::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B*48.0, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C*48.0, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        case kParamF: float2string (F, text, kVstMaxParamStrLen); break;
        case kParamG: float2string (G, text, kVstMaxParamStrLen); break;
        case kParamH: float2string (H, text, kVstMaxParamStrLen); break;
        case kParamI: float2string ((I-1.0)*48.0, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void MultiBandDistortion::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamF: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamG: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamH: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamI: strncpy (text, "dB", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
