/* ========================================
 *  NCSeventeen - NCSeventeen.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "NCSeventeen.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::NCSeventeen {

NCSeventeen::NCSeventeen()
{
	A = 0.0;
	B = 1.0;
	
	lastSampleL = 0.0;
	iirSampleAL = 0.0;
	iirSampleBL = 0.0;
	basslevL = 0.0;
	treblevL = 0.0;
	cheblevL = 0.0;
	
	lastSampleR = 0.0;
	iirSampleAR = 0.0;
	iirSampleBR = 0.0;
	basslevR = 0.0;
	treblevR = 0.0;
	cheblevR = 0.0;
	
	flip = false;

	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int NCSeventeen::getParameterCount() const
{
  return kNumParameters;
}

void NCSeventeen::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float NCSeventeen::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void NCSeventeen::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "LOUDER", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "Output", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void NCSeventeen::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A*24.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void NCSeventeen::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
