/* ========================================
 *  NodeDither - NodeDither.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "NodeDither.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::NodeDither {

NodeDither::NodeDither()
{
	A = 0.04;
	B = 0.0;
	for(int count = 0; count < 4999; count++) {dL[count] = 0; dR[count] = 0;}
	gcount = 0;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int NodeDither::getParameterCount() const
{
  return kNumParameters;
}

void NodeDither::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float NodeDither::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void NodeDither::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Node", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Phase", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void NodeDither::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: int2string ((int) floor(A * 100), text, kVstMaxParamStrLen); break;
        case kParamB: switch((int)( B * 1.999 )) //0 to almost edge of # of params
		{case 0: strncpy (text, "Out", kVstMaxParamStrLen); break;
		 case 1: strncpy (text, "In", kVstMaxParamStrLen); break;
		 default: break; // unknown parameter, shouldn't happen!
		} break; //completed D 'popup' parameter, exit
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void NodeDither::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "samples", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break; //the percent
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
