/* ========================================
 *  Pafnuty2 - Pafnuty2.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Pafnuty2.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Pafnuty2 {

Pafnuty2::Pafnuty2()
{
	A = 0.5;
	B = 0.5;
	C = 0.5;
	D = 0.5;
	E = 0.5;
	F = 0.5;
	G = 0.5;
	H = 0.5;
	I = 0.5;
	J = 0.5;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Pafnuty2::getParameterCount() const
{
  return kNumParameters;
}

void Pafnuty2::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        case kParamF: F = value; break;
        case kParamG: G = value; break;
        case kParamH: H = value; break;
        case kParamI: I = value; break;
        case kParamJ: J = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Pafnuty2::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        case kParamG: return G; break;
        case kParamH: return H; break;
        case kParamI: return I; break;
        case kParamJ: return J; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Pafnuty2::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Second", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Third", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Fourth", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Fifth", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Sixth", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "Seventh", kVstMaxParamStrLen); break;
		case kParamG: strncpy (text, "Eighth", kVstMaxParamStrLen); break;
		case kParamH: strncpy (text, "Ninth", kVstMaxParamStrLen); break;
		case kParamI: strncpy (text, "Tenth", kVstMaxParamStrLen); break;
		case kParamJ: strncpy (text, "Inv/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Pafnuty2::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string ((B*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamC: float2string ((C*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamD: float2string ((D*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamE: float2string ((E*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamF: float2string ((F*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamG: float2string ((G*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamH: float2string ((H*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamI: float2string ((I*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamJ: float2string ((J*2.0)-1.0, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Pafnuty2::getParameterLabel(int index, char *text) {
    strncpy (text, "", kVstMaxParamStrLen);
	//in this case I'm just not going to make 10 ways to say ""
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
