/* ========================================
 *  PitchDelay - PitchDelay.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "PitchDelay.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::PitchDelay {

PitchDelay::PitchDelay()
{
	A = 1.0;
	B = 0.0;
	C = 0.5;
	D = 0.0;
	E = 0.5;
	F = 1.0;
	
	for(int x = 0; x < 88210; x++) {dL[x] = 0.0; dR[x] = 0.0;}
	prevSampleL = 0.0; regenSampleL = 0.0; delayL = 0.0; sweepL = 0.0;
	prevSampleR = 0.0; regenSampleR = 0.0; delayR = 0.0; sweepR = 0.0;
	for (int x = 0; x < 9; x++) {
		regenFilterL[x] = 0.0; outFilterL[x] = 0.0; lastRefL[x] = 0.0;
		regenFilterR[x] = 0.0; outFilterR[x] = 0.0; lastRefR[x] = 0.0;
	}
	cycle = 0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int PitchDelay::getParameterCount() const
{
  return kNumParameters;
}

void PitchDelay::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        case kParamF: F = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float PitchDelay::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void PitchDelay::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Time", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Regen", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Freq", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Reso", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Pitch", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void PitchDelay::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        case kParamF: float2string (F, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void PitchDelay::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamF: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
