/* ========================================
 *  Podcast - Podcast.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Podcast_Podcast_H
#define __Podcast_Podcast_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Podcast {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class Podcast final : public SfxCoreExtensionV1
{
public:
    Podcast();
    ~Podcast();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double c1L;
	double c2L;
	double c3L;
	double c4L;
	double c5L;
	//the compressor
	
	double c1R;
	double c2R;
	double c3R;
	double c4R;
	double c5R;
	//the compressor
	
    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
