/* ========================================
 *  Pop2 - Pop2.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Pop2.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Pop2 {

Pop2::Pop2()
{
	A = 0.5;
	B = 0.5;
	C = 0.5;
	D = 0.5;
	E = 1.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	
	lastSampleL = 0.0;
	wasPosClipL = false;
	wasNegClipL = false;
	lastSampleR = 0.0;
	wasPosClipR = false;
	wasNegClipR = false;
	for (int x = 0; x < 16; x++) {intermediateL[x] = 0.0; intermediateR[x] = 0.0;}	
	
	muVaryL = 0.0;
	muAttackL = 0.0;
	muNewSpeedL = 1000.0;
	muSpeedAL = 1000.0;
	muSpeedBL = 1000.0;
	muCoefficientAL = 1.0;
	muCoefficientBL = 1.0;
	
	muVaryR = 0.0;
	muAttackR = 0.0;
	muNewSpeedR = 1000.0;
	muSpeedAR = 1000.0;
	muSpeedBR = 1000.0;
	muCoefficientAR = 1.0;
	muCoefficientBR = 1.0;
	
	flip = false;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Pop2::getParameterCount() const
{
  return kNumParameters;
}

void Pop2::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Pop2::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Pop2::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Compres", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Attack", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Release", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Drive", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Pop2::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Pop2::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
