/* ========================================
 *  PurestSquish - PurestSquish.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "PurestSquish.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::PurestSquish {

PurestSquish::PurestSquish()
{
	A = 0.0;
	B = 0.0;
	C = 1.0;
	D = 1.0;

	muSpeedAL = 10000;
	muSpeedBL = 10000;
	muSpeedCL = 10000;
	muSpeedDL = 10000;
	muSpeedEL = 10000;
	muCoefficientAL = 1;
	muCoefficientBL = 1;
	muCoefficientCL = 1;
	muCoefficientDL = 1;
	muCoefficientEL = 1;
	iirSampleAL = 0.0;
	iirSampleBL = 0.0;
	iirSampleCL = 0.0;
	iirSampleDL = 0.0;
	iirSampleEL = 0.0;
	lastCoefficientAL = 1;
	lastCoefficientBL = 1;
	lastCoefficientCL = 1;
	lastCoefficientDL = 1;
	mergedCoefficientsL = 1;
	muVaryL = 1;

	muSpeedAR = 10000;
	muSpeedBR = 10000;
	muSpeedCR = 10000;
	muSpeedDR = 10000;
	muSpeedER = 10000;
	muCoefficientAR = 1;
	muCoefficientBR = 1;
	muCoefficientCR = 1;
	muCoefficientDR = 1;
	muCoefficientER = 1;
	iirSampleAR = 0.0;
	iirSampleBR = 0.0;
	iirSampleCR = 0.0;
	iirSampleDR = 0.0;
	iirSampleER = 0.0;
	lastCoefficientAR = 1;
	lastCoefficientBR = 1;
	lastCoefficientCR = 1;
	lastCoefficientDR = 1;
	mergedCoefficientsR = 1;
	muVaryR = 1;
	
	count = 1;
	fpFlip = true;
	
		fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int PurestSquish::getParameterCount() const
{
  return kNumParameters;
}

void PurestSquish::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float PurestSquish::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
         default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void PurestSquish::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Squish", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "BassBlm", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Output", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void PurestSquish::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void PurestSquish::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
