/* ========================================
 *  PurestSquish - PurestSquish.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __PurestSquish_PurestSquish_H
#define __PurestSquish_PurestSquish_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::PurestSquish {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class PurestSquish final : public SfxCoreExtensionV1
{
public:
    PurestSquish();
    ~PurestSquish();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;

	double muVaryL;
	double muAttackL;
	double muNewSpeedL;
	double muSpeedAL;
	double muSpeedBL;
	double muSpeedCL;
	double muSpeedDL;
	double muSpeedEL;
	double muCoefficientAL;
	double muCoefficientBL;
	double muCoefficientCL;
	double muCoefficientDL;
	double muCoefficientEL;
	double iirSampleAL;
	double iirSampleBL;
	double iirSampleCL;
	double iirSampleDL;
	double iirSampleEL;
	double lastCoefficientAL;
	double lastCoefficientBL;
	double lastCoefficientCL;
	double lastCoefficientDL;
	double mergedCoefficientsL;
	
	double muVaryR;
	double muAttackR;
	double muNewSpeedR;
	double muSpeedAR;
	double muSpeedBR;
	double muSpeedCR;
	double muSpeedDR;
	double muSpeedER;
	double muCoefficientAR;
	double muCoefficientBR;
	double muCoefficientCR;
	double muCoefficientDR;
	double muCoefficientER;
	double iirSampleAR;
	double iirSampleBR;
	double iirSampleCR;
	double iirSampleDR;
	double iirSampleER;
	double lastCoefficientAR;
	double lastCoefficientBR;
	double lastCoefficientCR;
	double lastCoefficientDR;
	double mergedCoefficientsR;
	
	int count;
	bool fpFlip;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
