/* ========================================
 *  Righteous4 - Righteous4.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Righteous4.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Righteous4 {

Righteous4::Righteous4()
{
	A = 0.0;
	B = 0.0;

	leftSampleA = 0.0;
	leftSampleB = 0.0;
	leftSampleC = 0.0;
	leftSampleD = 0.0;
	leftSampleE = 0.0;
	leftSampleF = 0.0;
	leftSampleG = 0.0;
	leftSampleH = 0.0;
	leftSampleI = 0.0;
	leftSampleJ = 0.0;
	leftSampleK = 0.0;
	leftSampleL = 0.0;
	leftSampleM = 0.0;
	leftSampleN = 0.0;
	leftSampleO = 0.0;
	leftSampleP = 0.0;
	leftSampleQ = 0.0;
	leftSampleR = 0.0;
	leftSampleS = 0.0;
	leftSampleT = 0.0;
	leftSampleU = 0.0;
	leftSampleV = 0.0;
	leftSampleW = 0.0;
	leftSampleX = 0.0;
	leftSampleY = 0.0;
	leftSampleZ = 0.0;
	
	rightSampleA = 0.0;
	rightSampleB = 0.0;
	rightSampleC = 0.0;
	rightSampleD = 0.0;
	rightSampleE = 0.0;
	rightSampleF = 0.0;
	rightSampleG = 0.0;
	rightSampleH = 0.0;
	rightSampleI = 0.0;
	rightSampleJ = 0.0;
	rightSampleK = 0.0;
	rightSampleL = 0.0;
	rightSampleM = 0.0;
	rightSampleN = 0.0;
	rightSampleO = 0.0;
	rightSampleP = 0.0;
	rightSampleQ = 0.0;
	rightSampleR = 0.0;
	rightSampleS = 0.0;
	rightSampleT = 0.0;
	rightSampleU = 0.0;
	rightSampleV = 0.0;
	rightSampleW = 0.0;
	rightSampleX = 0.0;
	rightSampleY = 0.0;
	rightSampleZ = 0.0;
	
	bynL[0] = 1000;
	bynL[1] = 301;
	bynL[2] = 176;
	bynL[3] = 125;
	bynL[4] = 97;
	bynL[5] = 79;
	bynL[6] = 67;
	bynL[7] = 58;
	bynL[8] = 51;
	bynL[9] = 46;
	bynL[10] = 1000;
	noiseShapingL = 0.0;
	lastSampleL = 0.0;
	IIRsampleL = 0.0;
	gwPrevL = 0.0;
	gwAL = 0.0;
	gwBL = 0.0;
	
	bynR[0] = 1000;
	bynR[1] = 301;
	bynR[2] = 176;
	bynR[3] = 125;
	bynR[4] = 97;
	bynR[5] = 79;
	bynR[6] = 67;
	bynR[7] = 58;
	bynR[8] = 51;
	bynR[9] = 46;
	bynR[10] = 1000;
	noiseShapingR = 0.0;
	lastSampleR = 0.0;
	IIRsampleR = 0.0;
	gwPrevR = 0.0;
	gwAR = 0.0;
	gwBR = 0.0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Righteous4::getParameterCount() const
{
  return kNumParameters;
}

void Righteous4::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Righteous4::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Righteous4::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "LTarget", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "BtDepth", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Righteous4::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*24.0)-28.0, text, kVstMaxParamStrLen); break;
        case kParamB: switch((int)( B * 2.999 )) //0 to almost edge of # of params
		{case 0: strncpy (text, "16", kVstMaxParamStrLen); break;
		 case 1: strncpy (text, "24", kVstMaxParamStrLen); break;
		 case 2: strncpy (text, "32", kVstMaxParamStrLen); break;
		 default: break; // unknown parameter, shouldn't happen!
		} break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Righteous4::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "bit", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
