/* ========================================
 *  SlewSonic - SlewSonic.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "SlewSonic.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::SlewSonic {

SlewSonic::SlewSonic()
{
	A = 0.5;
	B = 0.0;
	for (int x = 0; x < 15; x++) {
		biquadA[x] = 0.0;
		biquadB[x] = 0.0;
		biquadC[x] = 0.0;
		biquadD[x] = 0.0;
	}
	lastSampleAL = lastSampleBL = lastSampleCL = 0.0;
	lastSampleAR = lastSampleBR = lastSampleCR = 0.0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int SlewSonic::getParameterCount() const
{
  return kNumParameters;
}

void SlewSonic::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float SlewSonic::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void SlewSonic::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Mute", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Bright", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void SlewSonic::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*20.0)+5.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void SlewSonic::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "kHz", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
