/* ========================================
 *  StereoChorus - StereoChorus.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __StereoChorus_StereoChorus_H
#define __StereoChorus_StereoChorus_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::StereoChorus {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class StereoChorus final : public SfxCoreExtensionV1
{
public:
    StereoChorus();
    ~StereoChorus();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	int pL[65536];
	int pR[65536];
	double sweepL;
	double sweepR;
	int	gcount;
	double airPrevL;
	double airEvenL;
	double airOddL;
	double airFactorL;
	double airPrevR;
	double airEvenR;
	double airOddR;
	double airFactorR;
	bool flip;
	
	double lastRefL[7];
	double lastRefR[7];
	int cycle;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
