/* ========================================
 *  TapeDelay - TapeDelay.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "TapeDelay.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::TapeDelay {

TapeDelay::TapeDelay()
{
	A = 1.0;
	B = 0.0;
	C = 0.5;
	D = 0.0; //0 to 130%
	E = 1.0; //-1.0 to 1.0
	F = 0.0; //8 taps
	
	for(int count = 0; count < 257; count++) {pL[count] = 0;pR[count] = 0;}
	for(delay = 0; delay < 44100; delay++) {dL[delay] = 0.0;dR[delay] = 0.0;}
	maxdelay = 0;
	delay = 0;
	gcount = 0;
	chase = 0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int TapeDelay::getParameterCount() const
{
  return kNumParameters;
}

void TapeDelay::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        case kParamF: F = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float TapeDelay::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void TapeDelay::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Dry", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Wet", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Delay", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Feedbak", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Lean/Ft", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "Depth", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void TapeDelay::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (((E*2.0)-1.0), text, kVstMaxParamStrLen); break;//-1.0 to 1.0
        case kParamF: float2string (floor((F*29.0)+3.0), text, kVstMaxParamStrLen); break;//taps 3 8 default 32
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void TapeDelay::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamF: strncpy (text, "taps", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
