/* ========================================
 *  TapeFat - TapeFat.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "TapeFat.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::TapeFat {

TapeFat::TapeFat()
{
	A = 1.0;
	B = 0.0;
	
	for(int count = 0; count < 257; count++) {pL[count] = 0;pR[count] = 0;}
	gcount = 0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int TapeFat::getParameterCount() const
{
  return kNumParameters;
}

void TapeFat::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float TapeFat::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void TapeFat::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Lean/Ft", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Depth", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void TapeFat::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (((A*2.0)-1.0), text, kVstMaxParamStrLen); break;
        case kParamB: float2string (floor((B*29.0)+3.0), text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void TapeFat::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "taps", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
