/* ========================================
 *  Texturize - Texturize.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Gain_Texturize_H
#define __Gain_Texturize_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Texturize {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class Texturize final : public SfxCoreExtensionV1
{
public:
    Texturize();
    ~Texturize();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	bool polarityL;
	double lastSampleL;
	double iirSampleL;
	double noiseAL;
	double noiseBL;
	double noiseCL;
	bool flipL;

	bool polarityR;
	double lastSampleR;
	double iirSampleR;
	double noiseAR;
	double noiseBR;
	double noiseCR;
	bool flipR;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
