/* ========================================
 *  ToVinyl4 - ToVinyl4.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __ToVinyl4_ToVinyl4_H
#define __ToVinyl4_ToVinyl4_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::ToVinyl4 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class ToVinyl4 final : public SfxCoreExtensionV1
{
public:
    ToVinyl4();
    ~ToVinyl4();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double ataLastOutL;
	double ataLastOutR;
	
	double s1L;
	double s2L;
	double s3L;
	double o1L;
	double o2L;
	double o3L;
	double m1L;
	double m2L;
	double s1R;
	double s2R;
	double s3R;
	double o1R;
	double o2R;
	double o3R;
	double m1R;
	double m2R;
	double desL;
	double desR;
	
	double midSampleA;
	double midSampleB;
	double midSampleC;
	double midSampleD;
	double midSampleE;
	double midSampleF;
	double midSampleG;
	double midSampleH;
	double midSampleI;
	double midSampleJ;
	double midSampleK;
	double midSampleL;
	double midSampleM;
	double midSampleN;
	double midSampleO;
	double midSampleP;
	double midSampleQ;
	double midSampleR;
	double midSampleS;
	double midSampleT;
	double midSampleU;
	double midSampleV;
	double midSampleW;
	double midSampleX;
	double midSampleY;
	double midSampleZ;
	
	double sideSampleA;
	double sideSampleB;
	double sideSampleC;
	double sideSampleD;
	double sideSampleE;
	double sideSampleF;
	double sideSampleG;
	double sideSampleH;
	double sideSampleI;
	double sideSampleJ;
	double sideSampleK;
	double sideSampleL;
	double sideSampleM;
	double sideSampleN;
	double sideSampleO;
	double sideSampleP;
	double sideSampleQ;
	double sideSampleR;
	double sideSampleS;
	double sideSampleT;
	double sideSampleU;
	double sideSampleV;
	double sideSampleW;
	double sideSampleX;
	double sideSampleY;
	double sideSampleZ;
	
	double aMid[11];
	double bMid[11];
	double fMid[11];		
	double aSide[11];
	double bSide[11];
	double fSide[11];		
	double aMidPrev;
	double aSidePrev;
	double bMidPrev;
	double bSidePrev;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
