/* ========================================
 *  VoiceOfTheStarship - VoiceOfTheStarship.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __VoiceOfTheStarship_VoiceOfTheStarship_H
#define __VoiceOfTheStarship_VoiceOfTheStarship_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::VoiceOfTheStarship {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class VoiceOfTheStarship final : public SfxCoreExtensionV1
{
public:
    VoiceOfTheStarship();
    ~VoiceOfTheStarship();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
	
	double noiseAL;
	double noiseBL;
	double noiseCL;
	double noiseAR;
	double noiseBR;
	double noiseCR;
	
	int position;
	int quadratic;
	bool flipL;
	bool flipR;
	bool filterflip;
	
	double bL[11];
	double bR[11];
	
	double f[11];
	
	int lastAlgorithm;
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
