// SPDX-License-Identifier: Unlicense

#ifndef SFX_CORE_AIR_WINDOWS_H
#define SFX_CORE_AIR_WINDOWS_H

#include "../../configuration.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../../type.h"
#include <string>

namespace SfxCoreAirWindows
{
  void loadParameters(SfxCoreAirWindows_ sfxCoreAirWindows, int instance, const float* params, int paramCount);
  std::u8string saveParameters(SfxCoreAirWindows_ sfxCoreAirWindows, int instance);
  void processBlock(SfxCoreAirWindows_ sfxCoreAirWindows, int instance, float** inBlock, float** outBlock, int blockSize);


  int getParameterCount(SfxCoreAirWindows_ sfxCoreAirWindows);
  float getParameter(SfxCoreAirWindows_ sfxCoreAirWindows, int instance, int param);
  void setParameter(SfxCoreAirWindows_ sfxCoreAirWindows, int instance, int param, float value);
  void getParameterLabel(SfxCoreAirWindows_ sfxCoreAirWindows, int instance, int param, char* text);
  void getParameterName(SfxCoreAirWindows_ sfxCoreAirWindows, int instance, int param, char* text);
  void getParameterDisplay(SfxCoreAirWindows_ sfxCoreAirWindows, int instance, int param, char* text);

  //void fixOrder(AirWindows airWindow, int instance, int instance2);
}

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif // SFX_CORE_AIR_WINDOWS_H
