/*
  ZynAddSubFX - a software synthesizer

  FilterParams.h - Parameters for filter
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu


  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef FILTER_PARAMS_H
#define FILTER_PARAMS_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "Defines.h"

class FilterParams
{
public:
  FilterParams(u8 Ptype_, u8 Pfreq, u8 Pq_);

  void defaults();

  void getfromFilterParams(FilterParams* pars);

  f32 getfreq();
  f32 getq();
  f32 getfreqtracking(f32 notefreq);
  f32 getgain();

  u8 Pcategory;	//Filter category (Analog/Formant/StVar)
  u8 Ptype;		// Filter type  (for analog lpf,hpf,bpf..)
  u8 Pfreq;		// Frequency (64-central frequency)
  u8 Pq;		// Q parameters (resonance or bandwidth)
  u8 Pstages;	//filter stages+1
  u8 Pfreqtrack;	//how the filter frequency is changing according the note frequency
  u8 Pgain;		//filter's output gain

  //Formant filter parameters
  u8 Pnumformants;	//how many formants are used
  u8 Pformantslowness;	//how slow varies the formants
  u8 Pvowelclearness;	//how vowels are kept clean (how much try to avoid "mixed" vowels)
  u8 Pcenterfreq, Poctavesfreq;	//the center frequency of the res. func., and the number of octaves

  struct
  {
    struct
    {
      unsigned char freq, amp, q;	//frequency,amplitude,Q
    } formants[FF_MAX_FORMANTS];
  } Pvowels[FF_MAX_VOWELS];


  u8 Psequencesize;	//how many vowels are in the sequence
  u8 Psequencestretch;	//how the sequence is stretched (how the input from filter envelopes/LFOs/etc. is "stretched")
  u8 Psequencereversed;	//if the input from filter envelopes/LFOs/etc. is reversed(negated)
  struct
  {
    unsigned char nvowel;	//the vowel from the position
  } Psequence[FF_MAX_SEQUENCE];

  void formantfilterH(i32 nvowel, i32 nfreqs, f32* freqs);	//used by UI

  bool changed = false;

  f32 getcenterfreq();
  f32 getoctavesfreq();
  f32 getfreqpos(f32 freq);
  f32 getfreqx(f32 x);
  f32 getformantfreq(u8 freq);
  f32 getformantamp(u8 amp);
  f32 getformantq(u8 q);


private:
  void defaults(i32 n);

  //stored default parameters
  u8 Dtype;
  u8 Dfreq;
  u8 Dq;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
