/*
  ZynAddSubFX - a software synthesizer

  SV Filter.h - Several state-variable filters
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef SV_FILTER_H
#define SV_FILTER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "Defines.h"
#include "FilterBase.h"

class SVFilter : public FilterBase
{
public:
  SVFilter(unsigned char Ftype, f32 Ffreq, f32 Fq, unsigned char Fstages);
  void filterout(f32* smp, i32 blockSize) override;
  void setfreq(f32 frequency) override;
  void setfreq_and_q(f32 frequency, f32 q_) override;
  void setq(f32 q_) override;

  void settype(i32 type_);
  void setgain(f32 dBgain) override;
  void setstages(i32 stages_);
  void cleanup();

private:
  struct fstage
  {
    f32 low, high, band, notch;
  } st[MAX_FILTER_STAGES + 1];

  struct parameters
  {
    f32 f, q, q_sqrt;
  } par, ipar;

  void singlefilterout(f32* smp, fstage& x, parameters& par, i32 blockSize);
  void computefiltercoefs();

  i32 type;			//The type of the filter (LPF1,HPF1,LPF2,HPF2...)
  i32 stages;			//how many times the filter is applied (0->1,1->2,etc.)
  i32 abovenq;			//this is 1 if the frequency is above the nyquist
  i32 oldabovenq;
  i32 needsinterpolation = 0, firsttime = 1;

  f32 freq;		//Frequency given in Hz
  f32 q;			//Q factor (resonance or Q factor)
  f32 gain = 1.0f;		//the gain of the filter (if are shelf/peak) filters
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
