/*
  ZynAddSubFX - a software synthesizer

  Waveshaper.h - Distortion Effect
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified and evolved for rakarrack by Josep Andreu & Ryan Billing

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef WAVESHAPER_H
#define WAVESHAPER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#include "Defines.h"

class Waveshaper
{
public:
  Waveshaper();
  //Waveshaping
  void waveshapesmps(i32 n, f32* smps, i32 type,
    i32 drive, i32 eff);
  void cleanup();

  i32 period_coeff;

  f64 u_up;
  f64 u_down;

  f32 dthresh;  //dynamic threshold in compression waveshaper 
  f32 dyno;
  f32 dynodecay;  //dynamically control symmetry

  f32 compg;  //used by compression distortion
  f32 cratio;  //used by compression for hardness
  f32 tmpgain;  // compression distortion temp variable
  f32 ncSAMPLE_RATE;
  f32* temps;

  f32 R, P, Vgbias, Vsupp, Ip, Vmin, Vg, Vfactor, Vdyno;  //Valve1 Modeling variables.
  f32 mu, V2bias, Is, Vg2, vfact, ffact, Vlv2out, V2dyno; //Valve2 variables

  class Resample* U_Resample;
  class Resample* D_Resample;


};

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
