/*
  ZynAddSubFX - a software synthesizer

  Alienwah.h - "AlienWah" effect
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul


  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef ALIENWAH_H
#define ALIENWAH_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/EffectLFO.h"

#define MAX_ALIENWAH_DELAY 100

struct COMPLEXTYPE
{
  f32 a, b;
};

class Alienwah
{
public:
  Alienwah();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);

  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;

private:
  //Parametrii Alienwah
  EffectLFO lfo;		//lfo-ul Alienwah
  i32 Pvolume;
  i32 Ppanning;
  i32 Pdepth;		//the depth of the Alienwah
  i32 Pfb;		//feedback
  i32 Plrcross;	//feedback
  i32 Pdelay;
  i32 Pphase;

  i32 oldk;
  i32 oldpdelay = 0;

  //Control Parametrii
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setdepth(i32 Pdepth);
  void setfb(i32 Pfb);
  void setlrcross(i32 Plrcross);
  void setdelay(i32 Pdelay);
  void setphase(i32 Pphase);

  //Valorile interne
  f32 panning, fb, depth, lrcross, phase;
  struct COMPLEXTYPE oldl[MAX_ALIENWAH_DELAY], oldr[MAX_ALIENWAH_DELAY];
  COMPLEXTYPE oldclfol, oldclfor;

};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
