/*
 
  CompBand.h - 4 Bands Compressor

  Using Compressor and AnalogFilters by other authors.

  Based on artscompressor.cc by Matthias Kretz <kretz@kde.org>
  Stefan Westerfeld <stefan@space.twc.de> 
  Modified by Ryan Billing & Josep Andreu
  
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul
  ZynAddSubFX - a software synthesizer
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef COMPBANDL_H
#define COMPBANDL_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"
#include "../common/Compressor.h"

class CompBand
{
public:
  CompBand();
  void processBlock(const f32* const* inBlock, f32** outBlock, const i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;
  f32 level;

  f32 lowl[Const::audioMaximumPossibleBlockSize];
  f32 lowr[Const::audioMaximumPossibleBlockSize];
  f32 midll[Const::audioMaximumPossibleBlockSize];
  f32 midlr[Const::audioMaximumPossibleBlockSize];
  f32 midhl[Const::audioMaximumPossibleBlockSize];
  f32 midhr[Const::audioMaximumPossibleBlockSize];
  f32 highl[Const::audioMaximumPossibleBlockSize];
  f32 highr[Const::audioMaximumPossibleBlockSize];

private:
  void setvolume (i32 Pvolume);
  void setlevel(i32 value);
  void setratio (i32 ch, i32 value);
  void setthres (i32 ch, i32 value);
  void setCross1 (i32 value);
  void setCross2 (i32 value);
  void setCross3 (i32 value);

  //Parametrii
  i32 Pvolume = 50;	//Volumul or E/R
  i32 Plevel;
  i32 PLratio;
  i32 PMLratio;
  i32 PMHratio;
  i32 PHratio;
  i32 PLthres;
  i32 PMLthres;
  i32 PMHthres;
  i32 PHthres;

  i32 Cross1;
  i32 Cross2;
  i32 Cross3;
  
  //Parametrii reali
  AnalogFilter lpf1l;
  AnalogFilter lpf1r;
  AnalogFilter hpf1l;
  AnalogFilter hpf1r;
  AnalogFilter lpf2l;
  AnalogFilter lpf2r;
  AnalogFilter hpf2l;
  AnalogFilter hpf2r;
  AnalogFilter lpf3l;
  AnalogFilter lpf3r;
  AnalogFilter hpf3l;
  AnalogFilter hpf3r;

  Compressor CL;
  Compressor CML;
  Compressor CMH;
  Compressor CH;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif // COMPBANDL_H
