/*
  Convolotron.h - Convolotron Effect

  Author: Ryam Billing & Jospe Andreu

  Adapted effect structure of ZynAddSubFX - a software synthesizer
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef CONVOLOTRON_H
#define CONVOLOTRON_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#ifdef SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON

#include "../common/Defines.h"
#include "../common/Resample.h"

/* A pointer to a SF_INFO structure is passed to sf_open () and filled in.
** On write, the SF_INFO structure is filled in by the user and passed into
** sf_open ().
*/

class Convolotron
{
public:
  Convolotron(i32 DS = 6, i32 uq = 4, i32 dq = 2);
  void processBlock(f32** inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void setProfile(i32 value);
  void adjust(i32 DS, i32 blockSize);

  f32 outvolume;

private:

  i32 Pvolume = 50;	//This is master wet/dry mix like other FX...but I am finding it is not useful
  i32 Ppanning = 64;	//Panning
  i32 Plrcross = 100;	// L/R Mixing  // This is a mono effect, so lrcross and panning are pointless
  i32 Phidamp = 60;
  i32 Plevel;		//This should only adjust the level of the IR effect, and not wet/dry mix
  i32 Plength = 50;		//5...500 ms// Set maximum length of IR.
  i32 Pfb;		//-64 ... 64// amount of feedback
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void sethidamp(i32 Phidamp);
  void process_rbuf();

  i32 offset;
  i32 maxx_size, maxx_read, real_len = 0, length;
  i32 DS_state;
  i32 nPERIOD;
  i32 nSAMPLE_RATE;

  f64 u_up;
  f64 u_down;
  f32 nfSAMPLE_RATE;

  f32 lpanning, rpanning, hidamp, alpha_hidamp, convlength = 0.5f, oldl;
  f32* rbuf, * buf, * lxn;
  f32 templ[Const::audioMaximumPossibleBlockSize];
  f32 tempr[Const::audioMaximumPossibleBlockSize];

  f32 level;
  f32 fb = 0.0f;
  f32 feedback = 0.0f;
  f32 levpanl, levpanr;

  Resample M_Resample;
  Resample U_Resample;
  Resample D_Resample;
};

#endif // SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON

#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif // CONVOLOTRON_H
