/*
  ZynAddSubFX - a software synthesizer

  Echo.h - Echo Effect
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu

  Reverse Echo by Transmogrifox

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef ECHO_H
#define ECHO_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"

class Echo
{
public:
  Echo();
  void processBlock(const f32* const * inBlock, f32** outBlock, const i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;

  void Tempo2Delay(i32 delay);

private:
  //Parametrii
  i32 Pvolume = 50;	//Volumul or E/R
  i32 Ppanning = 64;	//Panning
  i32 Pdelay = 60;
  i32 Plrdelay = 100;	// L/R delay difference
  i32 Plrcross = 100;	// L/R Mixing
  i32 Pfb = 40;		//Feed-back-ul
  i32 Phidamp = 60;
  i32 Preverse;
  i32 Pdirect;

  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setdelay(i32 Pdelay);
  void setlrdelay(i32 Plrdelay);
  void setlrcross(i32 Plrcross);
  void setfb(i32 Pfb);
  void sethidamp(i32 Phidamp);
  void setreverse(i32 Preverse);
  void setdirect(i32 Pdirect);

  //Parametrii reali
  void initdelays();

  i32 dl, dr, delay, lrdelay = 0;
  i32 kl, kr, rvkl, rvkr, rvfl, rvfr;
  static const i32 maxx_delay = SAMPLE_RATE * MAX_DELAY;
  static const i32 fade = SAMPLE_RATE / 5; //1/5 SR fade time available;

  f32 ldelay[maxx_delay];
  f32 rdelay[maxx_delay];
  f32 oldl, oldr;		//pt. lpf
  f32 panning, lrcross, fb, hidamp, reverse;
  f32  Srate_Attack_Coeff;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
