/*
  ZynAddSubFX - a software synthesizer

  MuTroMojo.h - "WahWah" effect and others
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Ryan Billing

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef RYANWAH_H
#define RYANWAH_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/EffectLFO.h"
#include "../common/RBFilter.h"

class MuTroMojo
{
public:
  MuTroMojo();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);

  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;

private:

  void setvolume(i32 Pvolume);
  void setwidth(i32 Pwidth);
  void setampsns(i32 Pampsns);
  void reinitfilter();




  i32 Pvolume;		//For wet/dry mix
  i32 Ppanning;        //delete.  
  i32 Pwidth;		//0/127// The width of the lfo of the MuTroMojo
  i32 Pampsns = 0;	        //0/127//how the filter varies according to the input amplitude
  i32 Pampsnsinv = 0;	//-64/64//bias of the filter
  i32 Pampsmooth = 0;	//0/127//how smooth the input amplitude changes the filter, also for Pampsinsinv smoothing for wah wah pedal
  i32 Prange;		//10/5000Hz//how far filter can deviate.
  i32 Php;		//-64/64//high pass filter mix
  i32 Plp;		//-64/64//low pass filter mix
  i32 Pbp;		//-64/64//Bandpass filter mix
  i32 Pq;		//0/127//filter resonance.
  i32 Pqm = 1; //Qmode Set backward compatibility mode by default.	        
  i32 Pstages;		//0-6// counter// Filter stages
  i32 Pminfreq;		//30/800//set lowest freq in range.
  i32 variq;		//on-off//checkbox//Selects whether Q is varied w/ frequency to emulate a wahwah


  //Control Parametrii
  i32 Ftype;
  i32 Fstages;

  //Valorile interne

  f32 rpanning;
  f32 lpanning;
  f32 depth;
  f32 ampsns;
  f32 ampsmooth;
  f32 wahsmooth;
  f32 fbias;
  f32 oldfbias;
  f32 oldfbias1;
  f32 oldfbias2;
  f32 q = 10.0f;
  f32 frequency = 40.0f;
  f32 maxfreq = 5000.0f;
  f32 base = 7.0f; //sets curve of modulation to frequency relationship
  f32 ibase = 1.0f / base;
  f32 minfreq = 40.0f;
  f32 ms1;
  f32 lpmix = 0.5f;
  f32 hpmix = 0.0f;
  f32 bpmix = 2.0f;	//mean squares
  f32 centfreq; //testing
  EffectLFO lfo;		//lfo-ul MuTroMojo
  RBFilter filterl;
  RBFilter filterr;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
