/*
  ZynAddSubFX - a software synthesizer

  Echo.h - Echo Effect
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef MUSDELAY_H
#define MUSDELAY_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"

class MusicalDelay
{
public:
  MusicalDelay();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;

private:

  void setvolume(i32 Pvolume);
  void setpanning(i32 num, i32 Ppanning);
  void setdelay(i32 num, i32 Pdelay);
  void setgain(i32 num, i32 Pgain);
  void setlrdelay(i32 Plrdelay);
  void setlrcross(i32 Plrcross);
  void setfb(i32 num, i32 Pfb);
  void sethidamp(i32 Phidamp);
  void settempo(i32 Ptempo);
  void initdelays();
  
  //Parametrii
  i32 Pvolume = 50;			//Volumul or E/R
  i32 Ppanning1 = 64;		//Panning
  i32 Ppanning2 = 64;
  i32 Pgain1 = 64;
  i32 Pgain2 = 64;
  i32 Pdelay1 = 60;
  i32 Pdelay2 = 60;
  i32 Plrdelay = 100;			// L/R delay difference
  i32 Plrcross = 100;			// L/R Mixing
  i32 Pfb1 = 40;			//Feed-back-ul
  i32 Pfb2 = 40;
  i32 Phidamp = 60;
  i32 Ptempo = 100;

  //Parametrii reali
  i32 dl1;
  i32 dr1;
  i32 dl2;
  i32 dr2;
  i32 delay1;
  i32 delay2;
  i32 lrdelay = 0;
  i32 kl1, kr1, kl2, kr2;
  i32 maxx_delay;
  f32 panning1, panning2, lrcross, fb1, fb2, hidamp;
  f32 gain1, gain2;
  f32* ldelay1, * rdelay1, * ldelay2, * rdelay2;
  f32 oldl1, oldr1, oldl2, oldr2;	//pt. lpf
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
