/*
  ZynAddSubFX - a software synthesizer

  Phaser.h - Phaser effect
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef PHASER_H
#define PHASER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/EffectLFO.h"

class Phaser
{
public:
  Phaser();
  void processBlock(const f32* const* inBlock, f32** outBlock, const i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();
  f32 outvolume;

private:
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setdepth(i32 Pdepth);
  void setfb(i32 Pfb);
  void setlrcross(i32 Plrcross);
  void setstages(i32 Pstages);
  void setphase(i32 Pphase);

  //Parametrii Phaser
  i32 Pvolume;
  i32 Ppanning;
  i32 Pdepth;		//the depth of the Phaser
  i32 Pfb;		//feedback
  i32 Plrcross;	//feedback
  i32 Pstages;
  i32 Poutsub;	//if I wish to substract the output instead of the adding it
  i32 Pphase;

  //Control Parametrii

  //Valorile interne
  f32 panning, fb, depth, lrcross, fbl, fbr, phase;
  f32 oldl[MAX_PHASER_STAGES * 2];
  f32 oldr[MAX_PHASER_STAGES * 2];
  f32 oldlgain, oldrgain;

  EffectLFO lfo;		//lfo-ul Phaser
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
