/*
  ZynAddSubFX - a software synthesizer

  Reverb.h - Reverberation effect
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  Modified for rakarrack by Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef REVERB_H
#define REVERB_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"

#define REV_COMBS 8
#define REV_APS 4

class Reverb
{
public:
  Reverb();
  void processBlock(const f32* const* inBlock, f32* const* outBlock, i32 blockSize);
  void cleanup();

  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);

  f32 outvolume;		//this is the volume of effect and is public because need it in system effect. The out volume of su

private:
  void setvolume(i32 Pvolume);
  void setpan(i32 Ppan);
  void settime(i32 Ptime);
  void setlohidamp(i32 Plohidamp);
  void setidelay(i32 Pidelay);
  void setidelayfb(i32 Pidelayfb);
  void sethpf(i32 Phpf);
  void setlpf(i32 Plpf);
  void settype(i32 Ptype);
  void setroomsize(i32 Proomsize);
  void processmono(i32 ch, f32* output, i32 blockSize);

  //Parametrii
  //Amount of the reverb,
  i32 Pvolume = 48;

  //LefT/Right Panning
  i32 Ppan = 64;

  //duration of reverb
  i32 Ptime = 64;

  //Initial delay 
  i32 Pidelay = 40;

  //Initial delay feedback
  i32 Pidelayfb = 0;

  //delay between ER/Reverbs
  i32 Prdelay = 0;

  //EarlyReflections/Reverb Balance
  i32 Perbalance = 64;

  //HighPassFilter 
  i32 Plpf = 127;

  //LowPassFilter
  i32 Phpf = 0;

  //Low/HighFrequency Damping
  i32 Plohidamp = 80;	// 0..63 lpf,64=off,65..127=hpf(TODO)

  //Reverb type
  i32 Ptype = 1;

  //Room Size
  i32 Proomsize = 64;

  //Parametrii 2  
  i32 lohidamptype;		//0=disable,1=highdamp(lowpass),2=lowdamp(highpass)
  i32 idelaylen, rdelaylen;
  i32 idelayk;
  i32 comblen[REV_COMBS * 2];
  i32 aplen[REV_APS * 2];

  i32 combk[REV_COMBS * 2];
  i32 apk[REV_APS * 2];

  f32 lohifb, idelayfb, roomsize = 1.0f, rs = 1.0f;	//rs is used to "normalise" the volume according to the roomsize
  f32 rs_coeff;
  //parameter control
  f32 pan, erbalance;

  //Valorile interne

  f32* comb[REV_COMBS * 2];

  f32 combfb[REV_COMBS * 2];	//feedback-ul fiecarui filtru "comb"
  f32 lpcomb[REV_COMBS * 2];	//pentru Filtrul LowPass

  f32* ap[REV_APS * 2];
  f32 inputbuf[Const::audioMaximumPossibleBlockSize];
  f32* idelay;

  //filters
  AnalogFilter lpf;
  AnalogFilter hpf;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
