/*
  Rakarrack Guitar FX

  Sustainer.h - Simple compressor/sustainer effect with easy interface, minimal controls
  Copyright (C) 2010 Ryan Billing
  Author: Ryan Billing

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 3 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef SUSTAINER_H
#define SUSTAINER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"

class Sustainer
{
public:
  Sustainer();
  void cleanup();

  void processBlock(f32** inOutBlock, i32 blockSize);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void setpreset(i32 npreset);

private:
  //Parametrii
  i32 Pvolume = 64;	//Output Level
  i32 Psustain = 64;	//Compression amount

  i32 timer;
  i32 hold;
  f32 level = 0.5f;
  f32 fsustain = 0.5f;
  f32 input;
  f32 tmpgain;
  f32 prls, compeak, compg, compenv, oldcompenv, calpha, cbeta, cthresh, cratio, cpthresh;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
