/*
  ZynAddSubFX - a software synthesizer
  Synthfilter.h - Synthesizer filter effect
  Copyright (C) 2010 Ryan Billing
  Based on Analog Phaser  derived from
  Phaser.h/.C
  Copyright (C) 2002-2005 Nasca Octavian Paul

  Authors: Nasca Octavian Paul, Ryan Billing, Josep Andreu

  Modified for rakarrack by Josep Andreu

  Further modified for rakarrack by Ryan Billing (Transmogrifox) to model Analog Phaser behavior 2009

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef SYNTHFILTER_H
#define SYNTHFILTER_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/EffectLFO.h"


class Synthfilter
{
public:
  Synthfilter();
  void processBlock(f32** inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  void cleanup();

  f32 outvolume;

private:

  //Control parameters
  void setvolume(i32 Pvolume);
  void setdistortion(i32 Pdistortion);
  void setwidth(i32 Pwidth);
  void setfb(i32 Pfb);
  void setdepth(i32 Pdepth);

  //Phaser parameters
  i32 Pvolume;			 //0//Used in Process.C to set wet/dry mix
  i32 Pdistortion;		 //1//0...127//Model distortion
  //2//Tempo//LFO frequency
  //3//0...127//LFO Random
  //4//0...max types//LFO Type
  //5//0...127//LFO stereo offset
  i32 Pwidth;			 //6//0...127//Phaser width (LFO amplitude)
  i32 Pfb;			 //7//-64...64//feedback
  i32 Plpstages;	         //8//0...12//Number of first-order Low-Pass stages
  i32 Phpstages;		 //9//0...12//Number of first-order High-Pass stages
  i32 Poutsub;			 //10//0 or 1//subtract the output instead of the adding it
  i32 Pdepth;			 //11//0...127//Depth of phaser sweep
  i32 Penvelope;		 //12//-64...64//envelope sensitivity
  i32 Pattack;			 //13//0...1000ms//Attack Time
  i32 Prelease;			 //14//0...500ms//Release Time
  i32 Pbandwidth;		 //15//0...127//Separate high pass & low pass

  //Internal Variables
  f32 distortion, fb, width, env, envdelta, sns, att, rls, fbl, fbr, depth, bandgain;
  f32* lyn1, * ryn1, * lx1hp, * ly1hp, * rx1hp, * ry1hp;
  f32 oldlgain, oldrgain, inv_period;

  f32 delta;
  f32 Rmin;	// 2N5457 typical on resistance at Vgs = 0
  f32 Rmax;	// Resistor parallel to FET
  f32 C, Clp, Chp;	        // Capacitor
  EffectLFO lfo;	         //Filter modulator
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
