/*
  ZynAddSubFX - a software synthesizer
  Copyright (C) 2002-2005 Nasca Octavian Paul
  Based on valve Steve Harris LADSPA plugin.
  Valve.h - Distorsion Effect

  Modified and adapted to rakarrack by Josep Andreu.

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

#ifndef VALVE_H
#define VALVE_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/AnalogFilter.h"
#include "../common/HarmonicEnhancer.h"

class Valve
{
public:
  Valve();
  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);
  f32 Wshape(f32 x);
  void cleanup();
  void applyfilters(f32** inOutBlock, i32 blockSize);

  f32 outvolume;

private:
  void setvolume(i32 Pvolume);
  void setpanning(i32 Ppanning);
  void setlrcross(i32 Plrcross);
  void setlpf(i32 Plpf);
  void sethpf(i32 Phpf);
  void setpresence(i32 value);
  void init_coefs();


  //Parametrii
  i32 Pvolume;	//Volumul or E/R
  i32 Ppanning;	//Panning
  i32 Plrcross;	// L/R Mixing
  i32 Pdrive;		//the input amplification
  i32 Plevel;		//the ouput amplification
  i32 Pnegate;	//if the input is negated 
  i32 Plpf;		//lowpass filter
  i32 Phpf;		//highpass filter
  i32 Pstereo;	//0=mono,1=stereo
  i32 Pprefiltering;	//if you want to do the filtering before the distorsion
  i32 Q_q;
  i32 Ped;
  i32 Presence;

  //Parametrii reali
  f32 panning, lrcross, q, dist, otml, otmr, itml, itmr, factor, atk;
  f32 rm[10] = { 1.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f };

  f32 coef;
  f32 qcoef;
  f32 fdist;
  f32 inputvol;

  AnalogFilter lpfl;
  AnalogFilter lpfr;
  AnalogFilter hpfl;
  AnalogFilter hpfr;
  HarmEnhancer harm;
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
