/*
  rakarrack - a guitar effects software

 Vibe.h  -  Vibe Effect definitions

  Copyright (C) 2008-2010 Ryan Billing
  Author: Josep Andreu & Ryan Billing

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/


#ifndef Vibe_H
#define Vibe_H

#include "../../../typedefs.h"

#ifdef SHR3D_SFX_CORE_RAKARRACK

#include "../common/Defines.h"
#include "../common/EffectLFO.h"

class Vibe
{
public:
  Vibe();

  void processBlock(const f32* const* inBlock, f32** outBlock, i32 blockSize);
  void setvolume(i32 value);
  void setpanning(i32 value);
  void setpreset(i32 npreset);
  void changepar(i32 npar, i32 value);
  i32 getpar(i32 npar);

  f32 outvolume;

private:
  i32 Pwidth;
  i32 Pfb;
  i32 Plrcross;
  i32 Pdepth;
  i32 Ppanning;
  i32 Pvolume;

  f32 fwidth;
  f32 fdepth;
  f32 rpanning, lpanning;
  f32 flrcross, fcross;
  f32 fb;
  EffectLFO lfo;

  f32 Ra, Rb, b, dTC, dRCl, dRCr, lampTC, ilampTC, minTC, alphal, alphar, stepl, stepr, oldstepl, oldstepr;
  f32 fbr, fbl;
  f32 dalphal, dalphar;
  f32 lstep, rstep;
  f32 cperiod;
  f32 gl, oldgl;
  f32 gr, oldgr;

  class fparams {
  public:
    f32 x1;
    f32 y1;
    //filter coefficients
    f32 n0;
    f32 n1;
    f32 d0;
    f32 d1;
  } vc[8], vcvo[8], ecvc[8], vevo[8], bootstrap[8];

  f32 vibefilter(f32 data, fparams* ftype, i32 stage);
  void init_vibes();
  void modulate(f32 ldrl, f32 ldrr);
  f32 bjt_shape(f32 data);

  f32 R1;
  f32 Rv;
  f32 C2;
  f32 C1[8];
  f32 beta;  //transistor forward gain.
  f32 gain, k;
  f32 oldcvolt[8];
  f32 en1[8], en0[8], ed1[8], ed0[8];
  f32 cn1[8], cn0[8], cd1[8], cd0[8];
  f32 ecn1[8], ecn0[8], ecd1[8], ecd0[8];
  f32 on1[8], on0[8], od1[8], od0[8];
};

#endif // SHR3D_SFX_CORE_RAKARRACK

#endif
