// SPDX-License-Identifier: Unlicense

#ifndef SFXPLUGINLV2_H
#define SFXPLUGINLV2_H

#include "configuration.h"

#ifdef SHR3D_SFX_PLUGIN_LV2

#include "type.h"

#include <string>

namespace SfxPluginLv2
{
  void init();

  bool hasSfxPluginWIndow(SfxIndex index);
  void openWindow(SfxIndex index, i32 instance);
  Size getSfxPluginWIndowSize(SfxIndex index);
  void closeWindow(SfxIndex index, i32 instance);

  void processBlock(SfxIndex index, i32 instance, f32** inBlock, f32** outBlock, i32 blockSize);

  std::string saveParameters(SfxIndex index, i32 instance);
  void loadParameters(SfxIndex index, i32 instance, const std::string& parameters);
}

#endif // SHR3D_SFX_PLUGIN_LV2

#endif // SFXPLUGINLV2_H
