// SPDX-License-Identifier: Unlicense

#ifndef SHADER_H
#define SHADER_H

#include "typedefs.h"

namespace Shader
{
  extern GLuint highwayFadeFar;
  extern GLint highwayFadeFarUniformViewDistance;
  extern GLint highwayFadeFarUniformFadeFarDistance;
  extern GLint highwayFadeFarUniformViewProjection;
  extern GLint highwayFadeFarUniformModel;
  extern GLint highwayFadeFarUniformColor;

  extern GLuint world;
  extern GLint worldUniformModelViewProjection;
  extern GLint worldUniformColor;

  extern GLuint worldNoTexture;
  extern GLint worldNoTextureUniformModelViewProjection;
  extern GLint worldNoTextureUniformColor;

  extern GLuint model;
  extern GLint modelUniformModelViewProjection;

  extern GLuint modelUvNotFlipped;
  extern GLint modelUvNotFlippedUniformModelViewProjection;

  extern GLuint worldVUMeterMono;
  extern GLint worldVUMeterMonoUniformModelViewProjection;
  extern GLint worldVUMeterMonoUniformVolume;
  extern GLint worldVUMeterMonoUniformPeakVolume;
  extern GLint worldVUMeterMonoUniformColor;
  extern GLint worldVUMeterMonoUniformColor2;
  extern GLint worldVUMeterMonoUniformColor3;

  extern GLuint worldVUMeterStereo;
  extern GLint worldVUMeterStereoUniformModelViewProjection;
  extern GLint worldVUMeterStereoUniformVolumeLeft;
  extern GLint worldVUMeterStereoUniformPeakVolumeLeft;
  extern GLint worldVUMeterStereoUniformVolumeRight;
  extern GLint worldVUMeterStereoUniformPeakVolumeRight;
  extern GLint worldVUMeterStereoUniformColor;
  extern GLint worldVUMeterStereoUniformColor2;
  extern GLint worldVUMeterStereoUniformColor3;

  extern GLuint worldTuner;
  extern GLint worldTunerUniformModelViewProjection;
  extern GLint worldTunerUniformCentsPos;
  extern GLint worldTunerUniform;
  extern GLint worldTunerUniformColor;
  extern GLint worldTunerUniformColor2;
  extern GLint worldTunerUniformColor3;

  extern GLuint worldTunerInFret;
  extern GLint worldTunerInFretUniformModelViewProjection;
  extern GLint worldTunerInFretUniformCentsPos;
  extern GLint worldTunerInFretUniform;
  extern GLint worldTunerInFretUniformColor;

  extern GLuint collisionChord;
  extern GLint collisionChordUniformSustain;
  extern GLint collisionChordUniformModelViewProjection;
  extern GLint collisionChordUniformColor;

  extern GLuint collisionFret;
  extern GLint collisionFretUniformModelViewProjection;
  extern GLint collisionFretUniformColor;

  extern GLuint collisionNote;
  extern GLint collisionNoteUniformModelViewProjection;
  extern GLint collisionNoteUniformColor;
  extern GLint collisionNoteUniformSustain;

  extern GLuint dotInlay;
  extern GLint dotInlayUniformModelViewProjection;
  extern GLint dotInlayUniformColor;
  extern GLint dotInlayUniformColor2;

  extern GLuint groundFret;
  extern GLint groundFretUniformViewDistance;
  extern GLint groundFretUniformFadeFarDistance;
  extern GLint groundFretUniformFadeNearDistance;
  extern GLint groundFretUniformFadeNearStrength;
  extern GLint groundFretUniformModel;
  extern GLint groundFretUniformViewProjection;
  extern GLint groundFretUniformColor;
  extern GLint groundFretUniformColor2;

  extern GLuint screen;

#ifdef SHR3D_FONT_BITMAP
  extern GLuint fontScreen;
  extern GLint fontScreenUniformColor;

  extern GLuint fontWorld;
  extern GLint fontWorldUniformModelViewProjection;
  extern GLint fontWorldUniformColor;

  extern GLuint fontWorldFadeFar;
  extern GLint fontWorldFadeFarUniformViewDistance;
  extern GLint fontWorldFadeFarUniformFadeFarDistance;
  extern GLint fontWorldFadeFarUniformViewProjection;
  extern GLint fontWorldFadeFarUniformModel;
  extern GLint fontWorldFadeFarUniformColor;

  extern GLuint fontWorldFadeFarAndNear;
  extern GLint fontWorldFadeFarAndNearUniformViewDistance;
  extern GLint fontWorldFadeFarAndNearUniformFadeFarDistance;
  extern GLint fontWorldFadeFarAndNearUniformFadeNearDistance;
  extern GLint fontWorldFadeFarAndNearUniformFadeNearStrength;
  extern GLint fontWorldFadeFarAndNearUniformViewProjection;
  extern GLint fontWorldFadeFarAndNearUniformModel;
  extern GLint fontWorldFadeFarAndNearUniformColor;

  extern GLuint fontRainbowScreen;
  extern GLint fontRainbowScreenUniformTime;
  extern GLint fontRainbowScreenUniformAlpha;

  //extern GLuint fontRainbowWorld;
  //extern GLint fontRainbowWorldUniformViewDistance;
  //extern GLint fontRainbowWorldUniformFadeFarDistance;
  //extern GLint fontRainbowWorldUniformViewProjection;
  //extern GLint fontRainbowWorldUniformModel;
  //extern GLint fontRainbowWorldUniformTime;
  //extern GLint fontRainbowWorldUniformAlpha;
#endif // SHR3D_FONT_BITMAP

#ifdef SHR3D_FONT_MSDF
  extern GLuint fontMSDFScreen;
  extern GLint fontMSDFScreenUniformColor;
  extern GLint fontMSDFScreenUniformScreenPxRange;

  extern GLuint fontMSDFWorld;
  extern GLint fontMSDFWorldUniformModelViewProjection;
  extern GLint fontMSDFWorldUniformColor;
  extern GLint fontMSDFWorldUniformScreenPxRange;

  extern GLuint fontMSDFWorldFadeFar;
  extern GLint fontMSDFWorldFadeFarUniformViewDistance;
  extern GLint fontMSDFWorldFadeFarUniformFadeFarDistance;
  extern GLint fontMSDFWorldFadeFarUniformViewProjection;
  extern GLint fontMSDFWorldFadeFarUniformModel;
  extern GLint fontMSDFWorldFadeFarUniformColor;
  extern GLint fontMSDFWorldFadeFarUniformScreenPxRange;

  extern GLuint fontMSDFWorldFadeFarAndNear;
  extern GLint fontMSDFWorldFadeFarAndNearUniformViewDistance;
  extern GLint fontMSDFWorldFadeFarAndNearUniformFadeFarDistance;
  extern GLint fontMSDFWorldFadeFarAndNearUniformFadeNearDistance;
  extern GLint fontMSDFWorldFadeFarAndNearUniformFadeNearStrength;
  extern GLint fontMSDFWorldFadeFarAndNearUniformViewProjection;
  extern GLint fontMSDFWorldFadeFarAndNearUniformModel;
  extern GLint fontMSDFWorldFadeFarAndNearUniformColor;
  extern GLint fontMSDFWorldFadeFarAndNearUniformScreenPxRange;

  extern GLuint fontMSDFRainbowScreen;
  extern GLint fontMSDFRainbowScreenUniformTime;
  extern GLint fontMSDFRainbowScreenUniformAlpha;
  extern GLint fontMSDFRainbowScreenUniformScreenPxRange;
#endif // SHR3D_FONT_MSDF

  extern GLuint groundAnchor;
  extern GLint groundAnchorUniformViewDistance;
  extern GLint groundAnchorUniformFadeFarDistance;
  extern GLint groundAnchorUniformFadeNearDistance;
  extern GLint groundAnchorUniformFadeNearStrength;
  extern GLint groundAnchorUniformModel;
  extern GLint groundAnchorUniformViewProjection;
  extern GLint groundAnchorUniformColor;
  extern GLint groundAnchorUniformColor2;
  extern GLint groundAnchorUniformColorExponent;

  extern GLuint groundBeat;
  extern GLint groundBeatUniformViewDistance;
  extern GLint groundBeatUniformFadeFarDistance;
  extern GLint groundBeatUniformViewProjection;
  extern GLint groundBeatUniformModel;
  extern GLint groundBeatUniformColor;

  extern GLuint groundBeatStrumDirection;
  extern GLint groundBeatStrumDirectionUniformViewDistance;
  extern GLint groundBeatStrumDirectionUniformFadeFarDistance;
  extern GLint groundBeatStrumDirectionUniformViewProjection;
  extern GLint groundBeatStrumDirectionUniformModel;
  extern GLint groundBeatStrumDirectionUniformColor;

  extern GLuint chordBox;
  extern GLint chordBoxUniformViewDistance;
  extern GLint chordBoxUniformFadeFarDistance;
  extern GLint chordBoxUniformViewProjection;
  extern GLint chordBoxUniformModel;
  extern GLint chordBoxUniformColor;

  extern GLuint chordBoxDoubleStop;
  extern GLint chordBoxDoubleStopUniformViewDistance;
  extern GLint chordBoxDoubleStopUniformFadeFarDistance;
  extern GLint chordBoxDoubleStopUniformViewProjection;
  extern GLint chordBoxDoubleStopUniformModel;
  extern GLint chordBoxDoubleStopUniformColor;

  extern GLuint chordBoxHighDensity;
  extern GLint chordBoxHighDensityUniformViewDistance;
  extern GLint chordBoxHighDensityUniformFadeFarDistance;
  extern GLint chordBoxHighDensityUniformViewProjection;
  extern GLint chordBoxHighDensityUniformModel;
  extern GLint chordBoxHighDensityUniformColor;

  extern GLuint chordBoxHighDensityDoubleStop;
  extern GLint chordBoxHighDensityDoubleStopUniformViewDistance;
  extern GLint chordBoxHighDensityDoubleStopUniformFadeFarDistance;
  extern GLint chordBoxHighDensityDoubleStopUniformViewProjection;
  extern GLint chordBoxHighDensityDoubleStopUniformModel;
  extern GLint chordBoxHighDensityDoubleStopUniformColor;

  extern GLuint chordBoxFretMute;
  extern GLint chordBoxFretMuteUniformViewDistance;
  extern GLint chordBoxFretMuteUniformFadeFarDistance;
  extern GLint chordBoxFretMuteUniformViewProjection;
  extern GLint chordBoxFretMuteUniformModel;
  extern GLint chordBoxFretMuteUniformColor;

  extern GLuint chordBoxPalmMute;
  extern GLint chordBoxPalmMuteUniformViewDistance;
  extern GLint chordBoxPalmMuteUniformFadeFarDistance;
  extern GLint chordBoxPalmMuteUniformViewProjection;
  extern GLint chordBoxPalmMuteUniformModel;
  extern GLint chordBoxPalmMuteUniformColor;

  extern GLuint chordBoxArpeggio;
  extern GLint chordBoxArpeggioUniformViewDistance;
  extern GLint chordBoxArpeggioUniformFadeFarDistance;
  extern GLint chordBoxArpeggioUniformViewProjection;
  extern GLint chordBoxArpeggioUniformModel;
  extern GLint chordBoxArpeggioUniformColor;

  extern GLuint timelineLevelScreen;
  extern GLint timelineLevelScreenUniformProgress;
  extern GLint timelineLevelScreenUniformSelectedLevel;
  extern GLint timelineLevelScreenUniformColor;
  extern GLint timelineLevelScreenUniformColor2;
  extern GLint timelineLevelScreenUniformColor3;
  extern GLint timelineLevelScreenUniformColor4;
  extern GLint timelineLevelScreenUniformColor5;
  extern GLint timelineLevelScreenUniformColor6;
  extern GLint timelineLevelScreenUniformColor7;
  extern GLint timelineLevelScreenUniformColor8;

#ifdef SHR3D_MUSIC_STRETCHER
  extern GLuint timelineMusicStretcherScreen;
  extern GLint timelineMusicStretcherScreenUniformProgress0;
  extern GLint timelineMusicStretcherScreenUniformProgress1;
  extern GLint timelineMusicStretcherScreenUniformColor;
  extern GLint timelineMusicStretcherScreenUniformColor2;
#endif // SHR3D_MUSIC_STRETCHER

  extern GLuint timelineSimpleScreen;
  extern GLint timelineSimpleScreenUniformProgress;
  extern GLint timelineSimpleScreenUniformColor;
  extern GLint timelineSimpleScreenUniformColor2;

  extern GLuint timelineToneScreen;
  extern GLint timelineToneScreenUniformProgress;
  extern GLint timelineToneScreenUniformTonePos;
  extern GLint timelineToneScreenUniformToneColor;

#ifdef SHR3D_OPENXR
  extern GLuint timelineLevelWorld;
  extern GLint timelineLevelWorldUniformProgress;
  extern GLint timelineLevelWorldUniformModelViewProjection;
  extern GLint timelineLevelWorldUniformSelectedLevel;
  extern GLint timelineLevelWorldUniformColor;
  extern GLint timelineLevelWorldUniformColor2;
  extern GLint timelineLevelWorldUniformColor3;
  extern GLint timelineLevelWorldUniformColor4;
  extern GLint timelineLevelWorldUniformColor5;
  extern GLint timelineLevelWorldUniformColor6;
  extern GLint timelineLevelWorldUniformColor7;
  extern GLint timelineLevelWorldUniformColor8;

  extern GLuint timelineSimpleWorld;
  extern GLint timelineSimpleWorldUniformProgress;
  extern GLint timelineSimpleWorldUniformModelViewProjection;
  extern GLint timelineSimpleWorldUniformColor;
  extern GLint timelineSimpleWorldUniformColor2;

  extern GLuint timelineToneWorld;
  extern GLint timelineToneWorldUniformProgress;
  extern GLint timelineToneWorldUniformModelViewProjection;
  extern GLint timelineToneWorldUniformTonePos;
  extern GLint timelineToneWorldUniformToneColor;

#ifdef SHR3D_MUSIC_STRETCHER
  extern GLuint timelineMusicStretcherWorld;
  extern GLint timelineMusicStretcherWorldUniformModelViewProjection;
  extern GLint timelineMusicStretcherWorldUniformProgress0;
  extern GLint timelineMusicStretcherWorldUniformProgress1;
  extern GLint timelineMusicStretcherWorldUniformColor;
  extern GLint timelineMusicStretcherWorldUniformColor2;
#endif // SHR3D_MUSIC_STRETCHER

  extern GLuint xrPointer;
  extern GLint xrPointerUniformModelViewProjection;
  extern GLint xrPointerUniformColor;
#ifdef PLATFORM_QUEST_3
  extern GLuint xrPointerUniformBlockIndexSceneMatrices;
#endif // PLATFORM_QUEST_3
#endif // SHR3D_OPENXR

  extern GLuint groundSustain;
  extern GLint groundSustainUniformViewDistance;
  extern GLint groundSustainUniformFadeFarDistance;
  extern GLint groundSustainUniformFadeNearDistance;
  extern GLint groundSustainUniformFadeNearStrength;
  extern GLint groundSustainUniformViewProjection;
  extern GLint groundSustainUniformModel;
  extern GLint groundSustainUniformColor;

  extern GLuint fret;
  extern GLint fretUniformModelViewProjection;
  extern GLint fretUniformFretPositionOffsetX;
  extern GLint fretUniformColor;

  extern GLuint scoreScreen;
  extern GLint scoreScreenUniformProgress;
  extern GLint scoreScreenUniformColor;
  extern GLint scoreScreenUniformColor2;

  extern GLuint string;
  extern GLint stringUniformModelViewProjection;
  extern GLint stringUniformColor;
  extern GLuint stringWound;
  extern GLint stringWoundUniformModelViewProjection;
  extern GLint stringWoundUniformColor;

  extern GLuint sustain;
  extern GLint sustainUniformViewDistance;
  extern GLint sustainUniformFadeFarDistance;
  extern GLint sustainUniformViewProjection;
  extern GLint sustainUniformModel;
  extern GLint sustainUniformColor;

  extern GLuint noteAccent;
  extern GLint noteAccentUniformViewDistance;
  extern GLint noteAccentUniformFadeFarDistance;
  extern GLint noteAccentUniformViewProjection;
  extern GLint noteAccentUniformModel;
  extern GLint noteAccentUniformColor;

  extern GLuint noteStand;
  extern GLint noteStandUniformViewDistance;
  extern GLint noteStandUniformFadeFarDistance;
  extern GLint noteStandUniformViewProjection;
  extern GLint noteStandUniformModel;
  extern GLint noteStandUniformColor;

  extern GLuint noteStandZero;
  extern GLint noteStandZeroUniformViewDistance;
  extern GLint noteStandZeroUniformFadeFarDistance;
  extern GLint noteStandZeroUniformViewProjection;
  extern GLint noteStandZeroUniformModel;
  extern GLint noteStandZeroUniformColor;

#ifdef SHR3D_RENDERER_DEVELOPMENT
  extern GLuint highwayFadeFarInstanced;
  extern GLint highwayFadeFarInstancedUniformViewDistance;
  extern GLint highwayFadeFarInstancedUniformFadeFarDistance;

  //extern GLuint groundFretInstanced;
  //extern GLint groundFretInstancedUniformViewDistance;
  //extern GLint groundFretInstancedUniformFadeFarDistance;
  //extern GLint groundFretInstancedUniformFadeNearDistance;
  //extern GLint groundFretInstancedUniformFadeNearStrength;
  //extern GLint groundFretInstancedUniformColor;
  //extern GLint groundFretInstancedUniformColor2;
#endif // SHR3D_RENDERER_DEVELOPMENT

#ifdef SHR3D_PARTICLE
  extern GLuint particleInstanced;
#endif // SHR3D_PARTICLE

  extern GLuint ui;
  extern GLint uiUniformModelViewProjection;
  extern GLint uiUniformResolution;
#ifdef PLATFORM_QUEST_3
  extern GLuint uiUniformBlockIndexSceneMatrices;
#endif // PLATFORM_QUEST_3

#ifdef SHR3D_ENVIRONMENT_SKYBOX
  extern GLuint skybox;
  extern GLint skyboxUniformModelViewProjection;
  extern GLint skyboxUniformRotation;
#endif // SHR3D_ENVIRONMENT_SKYBOX
#ifdef SHR3D_ENVIRONMENT_SKYBOX_CUBE_TEXTURE
  extern GLuint skyboxCubeTexture;
  extern GLint skyboxCubeTextureUniformModelViewProjection;
#endif // SHR3D_ENVIRONMENT_SKYBOX_CUBE_TEXTURE

  void init();
}

#endif // SHADER_H
