// SPDX-License-Identifier: Unlicense

#ifndef STRING__H
#define STRING__H

#include "typedefs.h"

#include <string>
#include <vector>

namespace String
{
#ifdef PLATFORM_WINDOWS
  std::wstring s2ws(const char8_t* str, i32 strSize); // for _wfopen on windows
  std::u8string ws2s(const wchar_t* str, i32 strSize);
  std::wstring ws_ExpandEnvironmentStrings(const std::wstring& wstr);
#endif // PLATFORM_WINDOWS

  std::vector<std::string> split(const std::string& str, const char delimiter);
  std::vector<std::u8string> split(const std::u8string& str, const char8_t delimiter);

  //i32 utf8CharCount(const char8_t* utf8String);
  char32_t utf32Char(const char8_t* utf8String, i8& utf8CharBytes);
}

std::u8string TODOFIX(const std::string& str);
std::string TODOFIX(const std::u8string& str);
i32 atoi2(const char8_t* str);
f64 atof2(const char8_t* str);
std::u8string to_string(bool value);
std::u8string to_string(u8 value);
std::u8string to_string(i8 value);
std::u8string to_string(u16 value);
std::u8string to_string(i16 value);
std::u8string to_string(u32 value);
std::u8string to_string(i32 value);
std::u8string to_string(u64 value);
std::u8string to_string(i64 value);
std::u8string to_string(f32 value);
std::u8string to_string(f64 value);

#endif // STRING__H
