// SPDX-License-Identifier: Unlicense

#ifndef TONES_H
#define TONES_H

#include "configuration.h"

#include "ini.h"

namespace Arrangement { struct Info; }

namespace Tones
{
  void init();
  void fini();

  void loadSongToneFile(const std::vector<Arrangement::Info>& arrangementInfos, const std::map<std::u8string, std::vector<Ini::KeyValue>>& tonesIni);
#ifndef PLATFORM_EMSCRIPTEN
  void saveSongToneFile(SongIndex songIndex);
#endif // PLATFORM_EMSCRIPTEN
}

#endif // TONES_H