# 🏗️ Building Shr3D

## 🔧 Prerequisites

- `g++` (for Linux build)
- `Visual Studio 2026` (for Windows build)
- `Android Studio` (for Mobile Platforms)
- `CMake` (for Debug builds / for Mobile Platforms)

### 🗔 Windows

**Release Build**

- run

	```batch
	buildWindows.bat
	```

> Note: If Visual Studio is installed in a non-default location, modify the path in `buildWindows.bat`

**Debug Build**

- run

	```batch
	cmake .
	```

- Open the generated `Shr3D.sln` in Visual Studio.

### 🐧 Linux

**Release Build**

- run

	```bash
	./buildLinux.sh
	```

**Debug Build**

- Open `CMakeLists.txt` in CLion or QtCreator and build it

### 📱 Mobile Platforms (Android / Pico4 / Quest 3)

**Prerequisites (android-sdl only)**

- Download [SDL-release-2.28.5](https://github.com/libsdl-org/SDL/releases/tag/release-2.28.5)
- Extract to `deps/SDL-release-2.28.5`

**Release Build**

- Open the respective project in Android Studio:
  - `android-sdl` for Tablet / Smartphone
  - `android-pico4` for Pico 4
  - `android-quest3` for Quest 3

- run the appropriate build script:

	```bash
	# For Android on Windows
	buildAndroid-sdl.bat
# 	# For Android on Linux
	./buildAndroid-sdl.sh
	
	# For Pico 4 on Windows
	buildAndroid-pico4.bat
	# For Pico 4 on Linux
	./buildAndroid-pico4.sh
	
	# For Quest 3 on Windows
	buildAndroid-quest3.bat
	# For Quest 3 on Linux
	./buildAndroid-quest3.sh
	```

**Debug Build**

- build the projects in Android Studio

> ⚠️ **Important**: For Pico 4, use Android Studio Dolphin 2021.3.1.16. The debugger will not attach on newer versions

### 🌐 Web (Emscripten)

**Prerequisites**

- grab the file and put them on your webserver

	```bash
	curl -O https://shr3d.app/app/index.html \
	     -O https://shr3d.app/app/shr3d.aw.js \
	     -O https://shr3d.app/app/shr3d.js \
	     -O https://shr3d.app/app/shr3d.wasm \
	     -O https://shr3d.app/app/shr3d.ww.js
	```

- Your server should include these headers:

	```
	Cross-Origin-Embedder-Policy: require-corp
	Cross-Origin-Opener-Policy: same-origin
	```

- You should be able to run shr3d in the browser.

**Release Build**

- run

	```bash
	./buildEmscripten.sh
	```

- Replace `shr3d.js` and `shr3d.wasm` on your webserver.

**Debug Build (for assert messages in the javascript console on your webbrowser)**

- run

	```bash
	./buildEmscriptenDebug.sh
	```

- Replace `shr3d.aw.js`, `shr3d.js` `shr3d.wasm` and `shr3d.ww.js` on your webserver.
