#!/bin/sh

# Ensure gradlew exists, otherwise, prompt to open the project in Android Studio
if [ ! -f "android-sdl/gradlew" ]; then
    echo "android-sdl/gradlew not found. Please open the project in Android Studio once."
    exit 1
fi

# Define the file path
filename1="src/version.h"

# Read the version numbers from the file
if [ -f "$filename1" ]; then
    while IFS=' ' read -r directive key value; do
        if [ "$directive" = "#define" ]; then
            case "$key" in
                VERSION_MAJOR) VERSION_MAJOR="$value" ;;
                VERSION_MINOR) VERSION_MINOR="$value" ;;
                VERSION_PATCH) VERSION_PATCH="$value" ;;
            esac
        fi
    done < "$filename1"
else
    echo "File $filename1 not found!"
    exit 1
fi

./android-sdl/gradlew -b android-sdl/build.gradle assembleRelease

cp android-sdl/build/outputs/apk/release/*.apk shr3d-$version-sdl.apk
