// SPDX-License-Identifier: Unlicense

#ifndef COLLECTION_H
#define COLLECTION_H

#include "configuration.h"
#include "typedefs.h"

#include <string>

namespace Song { struct Info; }

namespace Collection
{
#ifdef PLATFORM_EMSCRIPTEN
  void downloadFullSongWithProgress(SongIndex songIndex);
  void downloadAlbumCoverLoadAsTexture(Song::Info* songInfo);
#endif // PLATFORM_EMSCRIPTEN
  
  void init();
  void addSongFile(const std::string& filepath, const u8* songData, u64 songDataSize);
}

#endif // COLLECTION_H
