// SPDX-License-Identifier: Unlicense

#ifndef CONST_H
#define CONST_H

#include "type.h"

namespace Const
{
  inline constexpr f32 cursorHideCursorTimeout = 3.0f;
  inline constexpr i32 glMaxVertexMemory = 512 * 1024;
  inline constexpr i32 glMaxElementMemory = 128 * 1024;
  inline constexpr i32 audioMaximumPossibleBlockSize =
#ifdef PLATFORM_EMSCRIPTEN
    128;
#else // PLATFORM_EMSCRIPTEN
    2048;
#endif // PLATFORM_EMSCRIPTEN
  inline constexpr i16 controllerAxisDeadZone = 3000;
  inline constexpr i16 controllerTriggerDeadZone = -30000;
  inline constexpr f32 chordDetectorVolumeThreshhold = 0.005f;
#ifdef SHR3D_FONT_MSDF
  inline constexpr f32 fontMsdfScreenPxRange = 3.89219999f;
#endif // SHR3D_FONT_MSDF
  inline constexpr f32 highwayDrawChordNameEndDuration = 0.3f;
  inline constexpr f32 highwayDrawChordNameFadeOutDuration = 0.2f;
  inline constexpr f32 highwayDrawChordNameWaitDuration = 0.2f;
  inline constexpr f32 highwayDrawFretboardNearestNoteDistance = 1.0f;
  inline constexpr f32 highwayDrawHighDensityNoteFretNumberSkipDuration = 0.2f;
  inline constexpr f32 highwayDrawHighDensityChordSkipDuration = 0.5f;
  inline constexpr TimeNS highwayBeatDuration = 10_ms;
  inline constexpr f32 highwayFingerPreTime = 0.5f;
  inline constexpr f32 highwayNoteDetectionTimeOffset = 0.1f;
  inline constexpr f32 highwaySustainVibratoFrequency = 40.0f;
  inline constexpr f32 highwaySustainVibratoDampingBegin = 0.1f;
  inline constexpr f32 highwaySustainVibratoDampingEnd = 0.1f;
  inline constexpr f32 highwayStringFadeUnplayedFarDistance = 1.8f;
  inline constexpr f32 highwayStringFadeUnplayedNearDistance = 1.4f;
  inline constexpr f32 highwayStringFadeUnplayedDecayTime = 0.3f;
  inline constexpr f32 highwayStringFadeUnplayedAlpha = 0.3f;
  inline constexpr f32 highwayStringGaugeMultiplier = 0.2f;
  inline constexpr i32 highwayInstrumentBassStringCount = 6;
  inline constexpr i32 highwayInstrumentGuitarStringCount = 8;
#ifdef SHR3D_PARTICLE
  inline constexpr i32 highwayParticleMaxCount = 100000;
  inline constexpr f32 highwayParticleMaxSpawnsPerSecond = 100000.0f;
#endif // SHR3D_PARTICLE
  inline constexpr TimeNS highwayVUMeterPeakDuration = 2_s;
  inline constexpr f32 hudDrawSongInfoEndDuration = 4.0f;
  inline constexpr f32 hudDrawSongInfoFadeInDuration = 1.5f;
  inline constexpr f32 hudDrawSongInfoFadeOutDuration = 3.5f;
  inline constexpr f32 hudDrawSongInfoStartDuration = 1.0f;
  inline constexpr f32 hudDrawArrangementSwitchEndDuration = 3.0f;
  inline constexpr f32 hudDrawArrangementSwitchFadeInDuration = 0.5f;
  inline constexpr f32 hudDrawArrangementSwitchFadeOutDuration = 2.5f;
  inline constexpr f32 hudDrawSfxToneEndDuration = 3.0f;
  inline constexpr f32 hudDrawSfxToneFadeInDuration = 0.5f;
  inline constexpr f32 hudDrawSfxToneFadeOutDuration = 2.5f;
  inline constexpr f32 hudDrawToneSwitchTimerDuration = 3.0f;
  inline constexpr TimeNS hudLyricsHideIntroOutroDuration = 2_s;
#ifdef SHR3D_MUSIC_STRETCHER
  inline constexpr f32 musicStretcherMaxStretchRatio = 5.0f;
#endif // SHR3D_MUSIC_STRETCHER
  inline constexpr f32 sfxCoreTunerStrobeScrollSpeed = 50.0f;
  inline constexpr MidiNote stringStandardTuningGuitarZeroNote[] // Standard Tuning
  {
    MidiNote::E_4, // guitar first string (high E)
    MidiNote::B_3, // guitar second string
    MidiNote::G_3, // guitar third string
    MidiNote::D_3, // guitar fourth string
    MidiNote::A_2, // guitar fifth string
    MidiNote::E_2, // guitar sixth string (low E)
    MidiNote::B_1,
    MidiNote::F_sharp_1
  };
  inline constexpr MidiNote stringStandardTuningBassZeroNote[] // Standard Tuning
  {
    MidiNote::G_2, // bass first string
    MidiNote::D_2, // bass second string
    MidiNote::A_1, // bass third string
    MidiNote::E_1, // bass fourth string
    MidiNote::B_0,
    MidiNote::G_0
  };
  inline constexpr const char* noteNames[] = { "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B" };
  inline constexpr bool hasFretDotInlay[]{ 0,1,0,1,0,1,0,1,0,1,0,0,1,0,0,1,0,1,0,1,0,1,0,0,1 };
  inline constexpr i32 sfxToneTonesPerBank = 100;
  //inline constexpr i32 sfxFirstEmptyToneBank = 100;
  inline constexpr i32 playedNotesFromAudioMaxCount = 10000;
#ifdef SHR3D_MIDI
  inline constexpr i32 midiMaxDeviceCount = 32;
  inline constexpr const char* midiBindingsNames[] = {
    "MixerInstrument0VolumeCoarse",
    "MixerInstrument0VolumeFine",
    "MixerInstrument1VolumeCoarse",
    "MixerInstrument1VolumeFine",
    "MixerMusicVolumeCoarse",
    "MixerMusicVolumeFine",
    "EnvironmentClearColor.r",
    "EnvironmentClearColor.g",
    "EnvironmentClearColor.b",
    "HighwaySpeedMultiplierCoarse",
    "HighwaySpeedMultiplierFine",
    "SfxTone0",
    "SfxTone1",
    "SfxTone2",
    "SfxTone3",
    "SfxTone4",
    "SfxTone5",
    "SfxTone6",
    "SfxTone7",
    "SfxTone8",
    "SfxTone9",
    "SfxToneDec",
    "SfxToneInc",
    "SfxToneBankDec",
    "SfxToneBankInc",
    "Metronome",
    "MetronomeVolumeCoarse",
    "MetronomeVolumeFine",
    "Tuner",
#ifdef SHR3D_ENVIRONMENT_MILK
    "Milk",
#endif // SHR3D_ENVIRONMENT_MILK
    "OverallDifficulty",
    "Mute",
    "QuickRepeater",
    "QuickRepeaterJumpBegin",
    "MusicPlaybackPosition",
    //"MusicPlaybackPositionCoarse",
    //"MusicPlaybackPositionFine",
    "MusicStretchRatio"
  };
#endif // SHR3D_MIDI
}

#endif // CONST_H
